/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup.parallel;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.parallel.ITaskQueueMgr;
import com.netflix.priam.config.IConfiguration;
import java.util.AbstractSet;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CassandraBackupQueueMgr
implements ITaskQueueMgr<AbstractBackupPath> {
    private static final Logger logger = LoggerFactory.getLogger(CassandraBackupQueueMgr.class);
    private BlockingQueue<AbstractBackupPath> tasks;
    private AbstractSet<String> tasksQueued;

    @Inject
    public CassandraBackupQueueMgr(IConfiguration config) {
        this.tasks = new ArrayBlockingQueue<AbstractBackupPath>(config.getUncrementalBkupQueueSize());
        this.tasksQueued = new HashSet<String>(config.getUncrementalBkupQueueSize());
    }

    @Override
    public void add(AbstractBackupPath task) {
        if (!this.tasksQueued.contains(task.getRemotePath())) {
            this.tasksQueued.add(task.getRemotePath());
            try {
                this.tasks.put(task);
                logger.debug("Queued file {} within CF {}", (Object)task.getFileName(), (Object)task.getColumnFamily());
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted waiting for the task queue to have free space, not fatal will just move on.   Error Msg: {}", (Object)e.getLocalizedMessage());
            }
        } else {
            logger.debug("Already in queue, no-op.  File: {}", (Object)task.getRemotePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractBackupPath take() throws InterruptedException {
        AbstractBackupPath task = null;
        if (!this.tasks.isEmpty()) {
            BlockingQueue<AbstractBackupPath> blockingQueue = this.tasks;
            synchronized (blockingQueue) {
                task = (AbstractBackupPath)this.tasks.poll();
            }
        }
        return task;
    }

    @Override
    public Boolean hasTasks() {
        return !this.tasks.isEmpty();
    }

    @Override
    public void taskPostProcessing(AbstractBackupPath completedTask) {
        this.tasksQueued.remove(completedTask.getRemotePath());
    }

    @Override
    public Integer getNumOfTasksToBeProessed() {
        return this.tasks.size();
    }

    @Override
    public Boolean tasksCompleted(Date date) {
        throw new UnsupportedOperationException();
    }
}

