/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.compress;

import com.netflix.priam.compress.ChunkedStream;
import com.netflix.priam.compress.ICompression;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.xerial.snappy.SnappyInputStream;

public class SnappyCompression
implements ICompression {
    private static final int BUFFER = 2048;

    @Override
    public Iterator<byte[]> compress(InputStream is, long chunkSize) throws IOException {
        return new ChunkedStream(is, chunkSize);
    }

    @Override
    public void decompressAndClose(InputStream input, OutputStream output) throws IOException {
        try {
            this.decompress(input, output);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(InputStream input, OutputStream output) throws IOException {
        SnappyInputStream is = new SnappyInputStream((InputStream)new BufferedInputStream(input));
        byte[] data = new byte[2048];
        BufferedOutputStream dest1 = new BufferedOutputStream(output, 2048);
        try {
            int c;
            while ((c = is.read(data, 0, 2048)) != -1) {
                dest1.write(data, 0, c);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)dest1);
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

