/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.config;

import com.google.inject.ImplementedBy;
import com.netflix.priam.config.PriamConfiguration;
import com.netflix.priam.identity.config.InstanceDataRetriever;
import com.netflix.priam.scheduler.SchedulerType;
import com.netflix.priam.scheduler.UnsupportedTypeException;
import com.netflix.priam.tuner.GCType;
import com.netflix.priam.tuner.JVMOption;
import java.io.File;
import java.util.List;
import java.util.Map;

@ImplementedBy(value=PriamConfiguration.class)
public interface IConfiguration {
    public void intialize();

    public String getCassHome();

    default public String getCassConfigurationDirectory() {
        return new File(this.getYamlLocation()).getParentFile().getPath();
    }

    public String getYamlLocation();

    public String getJVMOptionsFileLocation();

    public GCType getGCType() throws UnsupportedTypeException;

    public Map<String, JVMOption> getJVMExcludeSet();

    public Map<String, JVMOption> getJVMUpsertSet();

    public String getCassStartupScript();

    public String getCassStopScript();

    public int getGracefulDrainHealthWaitSeconds();

    public int getRemediateDeadCassandraRate();

    public String getBackupLocation();

    public int getBackupRetentionDays();

    public List<String> getBackupRacs();

    public String getBackupPrefix();

    public String getRestorePrefix();

    public void setRestorePrefix(String var1);

    public List<String> getRestoreKeySpaces();

    public String getDataFileLocation();

    public String getLogDirLocation();

    public String getHintsLocation();

    public String getCacheLocation();

    public String getCommitLogLocation();

    public String getBackupCommitLogLocation();

    public long getBackupChunkSize();

    public int getJmxPort();

    public String getJmxUsername();

    public String getJmxPassword();

    public boolean enableRemoteJMX();

    public int getStoragePort();

    public int getSSLStoragePort();

    public int getNativeTransportPort();

    public String getSnitch();

    public String getAppName();

    public String getRac();

    public List<String> getRacs();

    public String getHostname();

    public String getInstanceName();

    public String getHeapSize();

    public String getHeapNewSize();

    default public String getCompactionCronExpression() {
        return "-1";
    }

    default public String getCompactionIncludeCFList() {
        return null;
    }

    default public String getCompactionExcludeCFList() {
        return null;
    }

    @Deprecated
    public int getBackupHour();

    public String getBackupCronExpression();

    public SchedulerType getBackupSchedulerType() throws UnsupportedTypeException;

    public String getSnapshotKeyspaceFilters();

    public String getSnapshotCFFilter();

    public String getIncrementalKeyspaceFilters();

    public String getIncrementalCFFilter();

    public String getRestoreKeyspaceFilter();

    public String getRestoreCFFilter();

    public String getRestoreSnapshot();

    public String getSDBInstanceIdentityRegion();

    public String getDC();

    public void setDC(String var1);

    public boolean isMultiDC();

    public int getMaxBackupUploadThreads();

    public int getMaxBackupDownloadThreads();

    public boolean isRestoreClosestToken();

    public String getASGName();

    public String getSiblingASGNames();

    public String getACLGroupName();

    public boolean isIncrBackup();

    public String getHostIP();

    public int getUploadThrottle();

    public InstanceDataRetriever getInstanceDataRetriever() throws InstantiationException, IllegalAccessException, ClassNotFoundException;

    public boolean isLocalBootstrapEnabled();

    public int getInMemoryCompactionLimit();

    public int getCompactionThroughput();

    public int getMaxHintWindowInMS();

    public int getHintedHandoffThrottleKb();

    public String getMaxDirectMemory();

    public String getBootClusterName();

    public String getSeedProviderName();

    public double getMemtableCleanupThreshold();

    public int getStreamingThroughputMB();

    public String getPartitioner();

    public String getKeyCacheSizeInMB();

    public String getKeyCacheKeysToSave();

    public String getRowCacheSizeInMB();

    public String getRowCacheKeysToSave();

    public String getCassProcessName();

    public String getAuthenticator();

    public String getAuthorizer();

    public boolean doesCassandraStartManually();

    public String getInternodeCompression();

    public boolean isBackingUpCommitLogs();

    public String getCommitLogBackupPropsFile();

    public String getCommitLogBackupArchiveCmd();

    public String getCommitLogBackupRestoreCmd();

    public String getCommitLogBackupRestoreFromDirs();

    public String getCommitLogBackupRestorePointInTime();

    public int maxCommitLogsRestore();

    public boolean isVpcRing();

    public void setRestoreKeySpaces(List<String> var1);

    public boolean isClientSslEnabled();

    public String getInternodeEncryption();

    public boolean isDynamicSnitchEnabled();

    public boolean isNativeTransportEnabled();

    public int getConcurrentReadsCnt();

    public int getConcurrentWritesCnt();

    public int getConcurrentCompactorsCnt();

    public int getCompactionLargePartitionWarnThresholdInMB();

    public String getExtraConfigParams();

    public String getCassYamlVal(String var1);

    public boolean getAutoBoostrap();

    public String getDseClusterType();

    public boolean isCreateNewTokenEnable();

    public String getPrivateKeyLocation();

    public String getRestoreSourceType();

    public boolean isEncryptBackupEnabled();

    public boolean isRestoreEncrypted();

    public String getAWSRoleAssumptionArn();

    public String getGcsServiceAccountId();

    public String getGcsServiceAccountPrivateKeyLoc();

    public String getPgpPasswordPhrase();

    public String getPgpPublicKeyLoc();

    public Map<String, String> getExtraEnvParams();

    public String getVpcId();

    public String getClassicEC2RoleAssumptionArn();

    public String getVpcEC2RoleAssumptionArn();

    public boolean isDualAccount();

    public Boolean isIncrBackupParallelEnabled();

    public int getIncrementalBkupMaxConsumers();

    public int getUncrementalBkupQueueSize();

    public int getTombstoneWarnThreshold();

    public int getTombstoneFailureThreshold();

    public int getStreamingKeepAlivePeriodInS();

    public String getFlushKeyspaces();

    @Deprecated
    public String getFlushInterval();

    public SchedulerType getFlushSchedulerType() throws UnsupportedTypeException;

    default public String getFlushCronExpression() {
        return "-1";
    }

    public String getBackupStatusFileLoc();

    public boolean useSudo();

    public String getBackupNotificationTopicArn();

    public boolean isPostRestoreHookEnabled();

    public String getPostRestoreHook();

    public String getPostRestoreHookHeartbeatFileName();

    public String getPostRestoreHookDoneFileName();

    public int getPostRestoreHookTimeOutInDays();

    default public int getPostRestoreHookHeartBeatTimeoutInMs() {
        return 120000;
    }

    default public int getPostRestoreHookHeartbeatCheckFrequencyInMs() {
        return 120000;
    }

    default public String getTunablePropertyFiles() {
        return "";
    }

    public String getProperty(String var1, String var2);
}

