/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.configSource;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.netflix.priam.configSource.AbstractConfigSource;
import com.netflix.priam.configSource.IConfigSource;
import java.util.Collection;

public class CompositeConfigSource
extends AbstractConfigSource {
    private final ImmutableCollection<? extends IConfigSource> sources;

    public CompositeConfigSource(ImmutableCollection<? extends IConfigSource> sources) {
        Preconditions.checkArgument((!sources.isEmpty() ? 1 : 0) != 0, (Object)"Can not create a composite config source without config sources!");
        this.sources = sources;
    }

    public CompositeConfigSource(Collection<? extends IConfigSource> sources) {
        this((ImmutableCollection<? extends IConfigSource>)ImmutableList.copyOf(sources));
    }

    public CompositeConfigSource(Iterable<? extends IConfigSource> sources) {
        this((ImmutableCollection<? extends IConfigSource>)ImmutableList.copyOf(sources));
    }

    public CompositeConfigSource(IConfigSource ... sources) {
        this((ImmutableCollection<? extends IConfigSource>)ImmutableList.copyOf((Object[])sources));
    }

    @Override
    public void intialize(String asgName, String region) {
        for (IConfigSource source : this.sources) {
            source.intialize(asgName, region);
        }
    }

    @Override
    public int size() {
        int size = 0;
        for (IConfigSource c : this.sources) {
            size += c.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public String get(String key) {
        Preconditions.checkNotNull((Object)key);
        for (IConfigSource c : this.sources) {
            String value = c.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void set(String key, String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value can not be null for configurations.");
        IConfigSource firstSource = (IConfigSource)Iterables.getFirst(this.sources, null);
        Preconditions.checkState((firstSource != null ? 1 : 0) != 0, (Object)"There was no IConfigSource found at the first location?");
        firstSource.set(key, value);
    }
}

