/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.configSource;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.priam.configSource.AbstractConfigSource;
import java.util.Map;
import java.util.Properties;

public final class SystemPropertiesConfigSource
extends AbstractConfigSource {
    private static final String BLANK = "";
    private final Map<String, String> data = Maps.newConcurrentMap();

    @Override
    public void intialize(String asgName, String region) {
        super.intialize(asgName, region);
        Properties systemProps = System.getProperties();
        for (String key : systemProps.stringPropertyNames()) {
            String value;
            if (!key.startsWith("priam") || (value = systemProps.getProperty(key)) == null || BLANK.equals(value)) continue;
            this.data.put(key, value);
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public String get(String key) {
        return this.data.get(key);
    }

    @Override
    public void set(String key, String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value can not be null for configurations.");
        this.data.put(key, value);
    }
}

