/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.cryptography.pgp;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredentialGeneric;

public class PgpCredential
implements ICredentialGeneric {
    private IConfiguration config;

    @Inject
    public PgpCredential(IConfiguration config) {
        this.config = config;
    }

    @Override
    public AWSCredentialsProvider getAwsCredentialProvider() {
        return null;
    }

    @Override
    public byte[] getValue(ICredentialGeneric.KEY key) {
        if (key == null) {
            throw new NullPointerException("Credential key cannot be null.");
        }
        if (key.equals((Object)ICredentialGeneric.KEY.PGP_PASSWORD)) {
            return this.config.getPgpPasswordPhrase().getBytes();
        }
        if (key.equals((Object)ICredentialGeneric.KEY.PGP_PUBLIC_KEY_LOC)) {
            return this.config.getPgpPublicKeyLoc().getBytes();
        }
        throw new IllegalArgumentException("Key value not supported.");
    }
}

