/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.google;

import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.netflix.priam.aws.S3BackupPath;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.google.GoogleEncryptedFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleFileIterator
implements Iterator<AbstractBackupPath> {
    private static final Logger logger = LoggerFactory.getLogger(GoogleFileIterator.class);
    private Date start;
    private Date till;
    private Iterator<AbstractBackupPath> iterator;
    private Provider<AbstractBackupPath> pathProvider;
    private String bucketName;
    private Storage.Objects objectsResoruceHandle = null;
    private Storage.Objects.List listObjectsSrvcHandle = null;
    private Objects objectsContainerHandle = null;
    private String pathWithinBucket;
    private String nextPageToken;

    public GoogleFileIterator(Provider<AbstractBackupPath> pathProvider, Storage gcsStorageHandle, String path, Date start, Date till) {
        this.start = start;
        this.till = till;
        this.pathProvider = pathProvider;
        this.objectsResoruceHandle = gcsStorageHandle.objects();
        if (path == null) {
            throw new NullPointerException("Path of object to fetch is null");
        }
        String[] paths = path.split(String.valueOf(S3BackupPath.PATH_SEP));
        if (paths.length < 1) {
            throw new IllegalStateException("Path of object to fetch is invalid.  Path: " + path);
        }
        this.bucketName = paths[0];
        this.pathWithinBucket = ((AbstractBackupPath)pathProvider.get()).remotePrefix(start, till, path);
        logger.info("Listing objects from GCS: {}, prefix: {}", (Object)this.bucketName, (Object)this.pathWithinBucket);
        try {
            this.listObjectsSrvcHandle = this.objectsResoruceHandle.list(this.bucketName);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get gcslist handle to bucket: " + this.bucketName, e);
        }
        this.listObjectsSrvcHandle.setPrefix(this.pathWithinBucket);
        try {
            this.iterator = this.createIterator();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception encountered fetching elements, msg: ." + e.getLocalizedMessage(), e);
        }
    }

    private Iterator<AbstractBackupPath> createIterator() throws Exception {
        ArrayList temp = Lists.newArrayList();
        this.objectsContainerHandle = (Objects)this.listObjectsSrvcHandle.execute();
        for (StorageObject object : this.objectsContainerHandle.getItems()) {
            String fileName = GoogleEncryptedFileSystem.parseObjectname(object.getName());
            logger.debug("id: {}, parse file name: {}, name: {}", new Object[]{object.getId(), fileName, object.getName()});
            AbstractBackupPath path = (AbstractBackupPath)this.pathProvider.get();
            path.parseRemote(object.getName());
            logger.debug("New key {} path = {} start: {} end: {} my {}", new Object[]{object.getName(), path.getRemotePath(), this.start, this.till, path.getTime()});
            if ((!path.getTime().after(this.start) || !path.getTime().before(this.till)) && !path.getTime().equals(this.start)) continue;
            temp.add(path);
            logger.debug("Added key {}", (Object)object.getName());
        }
        this.nextPageToken = this.objectsContainerHandle.getNextPageToken();
        return temp.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            return false;
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        if (this.nextPageToken == null) {
            return false;
        }
        try {
            this.listObjectsSrvcHandle.setPageToken(this.nextPageToken);
            this.iterator = this.createIterator();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception encountered fetching elements, see previous messages for details.", e);
        }
        return this.iterator.hasNext();
    }

    @Override
    public AbstractBackupPath next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
    }
}

