/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.identity;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IMembership;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.identity.token.IDeadTokenRetriever;
import com.netflix.priam.identity.token.INewTokenRetriever;
import com.netflix.priam.identity.token.IPreGeneratedTokenRetriever;
import com.netflix.priam.utils.ITokenManager;
import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.Sleeper;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InstanceIdentity {
    private static final Logger logger = LoggerFactory.getLogger(InstanceIdentity.class);
    public static final String DUMMY_INSTANCE_ID = "new_slot";
    private final ListMultimap<String, PriamInstance> locMap = Multimaps.newListMultimap(new HashMap(), (Supplier)new Supplier<List<PriamInstance>>(){

        public List<PriamInstance> get() {
            return Lists.newArrayList();
        }
    });
    private final IPriamInstanceFactory<PriamInstance> factory;
    private final IMembership membership;
    private final IConfiguration config;
    private final Sleeper sleeper;
    private final ITokenManager tokenManager;
    private final Predicate<PriamInstance> differentHostPredicate = new Predicate<PriamInstance>(){

        public boolean apply(PriamInstance instance) {
            return !instance.getInstanceId().equalsIgnoreCase(InstanceIdentity.DUMMY_INSTANCE_ID);
        }

        public boolean test(PriamInstance input) {
            return this.apply(input);
        }
    };
    private PriamInstance myInstance;
    private boolean isReplace = false;
    private boolean isTokenPregenerated = false;
    private String replacedIp = "";
    private IDeadTokenRetriever deadTokenRetriever;
    private IPreGeneratedTokenRetriever preGeneratedTokenRetriever;
    private INewTokenRetriever newTokenRetriever;

    @Inject
    public InstanceIdentity(IPriamInstanceFactory factory, IMembership membership, IConfiguration config, Sleeper sleeper, ITokenManager tokenManager, IDeadTokenRetriever deadTokenRetriever, IPreGeneratedTokenRetriever preGeneratedTokenRetriever, INewTokenRetriever newTokenRetriever) throws Exception {
        this.factory = factory;
        this.membership = membership;
        this.config = config;
        this.sleeper = sleeper;
        this.tokenManager = tokenManager;
        this.deadTokenRetriever = deadTokenRetriever;
        this.preGeneratedTokenRetriever = preGeneratedTokenRetriever;
        this.newTokenRetriever = newTokenRetriever;
        this.init();
    }

    public PriamInstance getInstance() {
        return this.myInstance;
    }

    public void init() throws Exception {
        this.myInstance = (PriamInstance)new RetryableCallable<PriamInstance>(){

            @Override
            public PriamInstance retriableCall() throws Exception {
                List deadInstances = InstanceIdentity.this.factory.getAllIds(InstanceIdentity.this.config.getAppName() + "-dead");
                for (PriamInstance ins : deadInstances) {
                    logger.info("[Dead] Iterating though the hosts: {}", (Object)ins.getInstanceId());
                    if (!ins.getInstanceId().equals(InstanceIdentity.this.config.getInstanceName())) continue;
                    ins.setOutOfService(true);
                    logger.info("[Dead]  found that this node is dead. application: {}, id: {}, instance: {}, region: {}, host ip: {}, host name: {}, token: {}", new Object[]{ins.getApp(), ins.getId(), ins.getInstanceId(), ins.getDC(), ins.getHostIP(), ins.getHostName(), ins.getToken()});
                    return ins;
                }
                List aliveInstances = InstanceIdentity.this.factory.getAllIds(InstanceIdentity.this.config.getAppName());
                for (PriamInstance ins : aliveInstances) {
                    logger.info("[Alive] Iterating though the hosts: {} My id = [{}]", (Object)ins.getInstanceId(), (Object)ins.getId());
                    if (!ins.getInstanceId().equals(InstanceIdentity.this.config.getInstanceName())) continue;
                    logger.info("[Alive]  found that this node is alive. application: {}, id: {}, instance: {}, region: {}, host ip: {}, host name: {}, token: {}", new Object[]{ins.getApp(), ins.getId(), ins.getInstanceId(), ins.getDC(), ins.getHostIP(), ins.getHostName(), ins.getToken()});
                    return ins;
                }
                return null;
            }
        }.call();
        if (null == this.myInstance) {
            this.myInstance = (PriamInstance)new RetryableCallable<PriamInstance>(){

                @Override
                public PriamInstance retriableCall() throws Exception {
                    PriamInstance result = null;
                    result = InstanceIdentity.this.deadTokenRetriever.get();
                    if (result != null) {
                        InstanceIdentity.this.isReplace = true;
                        if (InstanceIdentity.this.deadTokenRetriever.getReplaceIp() != null) {
                            InstanceIdentity.this.replacedIp = InstanceIdentity.this.deadTokenRetriever.getReplaceIp();
                        }
                    }
                    return result;
                }

                @Override
                public void forEachExecution() {
                    InstanceIdentity.this.populateRacMap();
                    InstanceIdentity.this.deadTokenRetriever.setLocMap((ListMultimap<String, PriamInstance>)InstanceIdentity.this.locMap);
                }
            }.call();
        }
        if (null == this.myInstance) {
            this.myInstance = (PriamInstance)new RetryableCallable<PriamInstance>(){

                @Override
                public PriamInstance retriableCall() throws Exception {
                    PriamInstance result = null;
                    result = InstanceIdentity.this.preGeneratedTokenRetriever.get();
                    if (result != null) {
                        InstanceIdentity.this.isTokenPregenerated = true;
                    }
                    return result;
                }

                @Override
                public void forEachExecution() {
                    InstanceIdentity.this.populateRacMap();
                    InstanceIdentity.this.preGeneratedTokenRetriever.setLocMap((ListMultimap<String, PriamInstance>)InstanceIdentity.this.locMap);
                }
            }.call();
        }
        if (null == this.myInstance) {
            if (this.config.isCreateNewTokenEnable()) {
                this.myInstance = (PriamInstance)new RetryableCallable<PriamInstance>(){

                    @Override
                    public PriamInstance retriableCall() throws Exception {
                        super.set(100, 100L);
                        InstanceIdentity.this.newTokenRetriever.setLocMap((ListMultimap<String, PriamInstance>)InstanceIdentity.this.locMap);
                        return InstanceIdentity.this.newTokenRetriever.get();
                    }

                    @Override
                    public void forEachExecution() {
                        InstanceIdentity.this.populateRacMap();
                        InstanceIdentity.this.newTokenRetriever.setLocMap((ListMultimap<String, PriamInstance>)InstanceIdentity.this.locMap);
                    }
                }.call();
            } else {
                throw new IllegalStateException("Node attempted to erroneously create a new token when we should be grabbing an existing token.");
            }
        }
        logger.info("My token: {}", (Object)this.myInstance.getToken());
    }

    private void populateRacMap() {
        this.locMap.clear();
        List<PriamInstance> instances = this.factory.getAllIds(this.config.getAppName());
        for (PriamInstance ins : instances) {
            this.locMap.put((Object)ins.getRac(), (Object)ins);
        }
    }

    public List<String> getSeeds() throws UnknownHostException {
        this.populateRacMap();
        LinkedList<String> seeds = new LinkedList<String>();
        if (this.config.getRacs().size() == 1) {
            PriamInstance instance;
            if (this.membership.getRacMembershipSize() != this.locMap.get((Object)this.myInstance.getRac()).size()) {
                return seeds;
            }
            if (this.locMap.get((Object)this.myInstance.getRac()).size() > 1 && ((PriamInstance)this.locMap.get((Object)this.myInstance.getRac()).get(0)).getHostIP().equals(this.myInstance.getHostIP()) && (instance = (PriamInstance)this.locMap.get((Object)this.myInstance.getRac()).get(1)) != null && !InstanceIdentity.isInstanceDummy(instance)) {
                if (this.config.isMultiDC()) {
                    seeds.add(instance.getHostIP());
                } else {
                    seeds.add(instance.getHostName());
                }
            }
        }
        for (String loc : this.locMap.keySet()) {
            PriamInstance instance = (PriamInstance)Iterables.tryFind((Iterable)this.locMap.get((Object)loc), this.differentHostPredicate).orNull();
            if (instance == null || InstanceIdentity.isInstanceDummy(instance)) continue;
            if (this.config.isMultiDC()) {
                seeds.add(instance.getHostIP());
                continue;
            }
            seeds.add(instance.getHostName());
        }
        return seeds;
    }

    public boolean isSeed() {
        this.populateRacMap();
        String ip = ((PriamInstance)this.locMap.get((Object)this.myInstance.getRac()).get(0)).getHostName();
        return this.myInstance.getHostName().equals(ip);
    }

    public boolean isReplace() {
        return this.isReplace;
    }

    public boolean isTokenPregenerated() {
        return this.isTokenPregenerated;
    }

    public String getReplacedIp() {
        return this.replacedIp;
    }

    private static boolean isInstanceDummy(PriamInstance instance) {
        return instance.getInstanceId().equals(DUMMY_INSTANCE_ID);
    }
}

