/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.identity.config;

import com.netflix.priam.identity.config.InstanceDataRetriever;
import com.netflix.priam.utils.SystemUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class InstanceDataRetrieverBase
implements InstanceDataRetriever {
    protected JSONObject identityDocument = null;

    @Override
    public String getPrivateIP() {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/local-ipv4");
    }

    @Override
    public String getRac() {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/placement/availability-zone");
    }

    @Override
    public String getPublicHostname() {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/public-hostname");
    }

    @Override
    public String getPublicIP() {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/public-ipv4");
    }

    @Override
    public String getInstanceId() {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/instance-id");
    }

    @Override
    public String getInstanceType() {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/instance-type");
    }

    @Override
    public String getMac() {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/network/interfaces/macs/").trim();
    }

    @Override
    public String getAWSAccountId() throws JSONException {
        if (this.identityDocument == null) {
            String jsonStr = SystemUtils.getDataFromUrl("http://169.254.169.254/latest/dynamic/instance-identity/document");
            this.identityDocument = new JSONObject(jsonStr);
        }
        return this.identityDocument.getString("accountId");
    }

    @Override
    public String getRegion() throws JSONException {
        if (this.identityDocument == null) {
            String jsonStr = SystemUtils.getDataFromUrl("http://169.254.169.254/latest/dynamic/instance-identity/document");
            this.identityDocument = new JSONObject(jsonStr);
        }
        return this.identityDocument.getString("region");
    }

    @Override
    public String getAvailabilityZone() throws JSONException {
        return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/placement/availability-zone");
    }
}

