/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.identity.token;

import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IMembership;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.identity.token.INewTokenRetriever;
import com.netflix.priam.identity.token.TokenRetrieverBase;
import com.netflix.priam.utils.ITokenManager;
import com.netflix.priam.utils.Sleeper;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTokenRetriever
extends TokenRetrieverBase
implements INewTokenRetriever {
    private static final Logger logger = LoggerFactory.getLogger(NewTokenRetriever.class);
    private IPriamInstanceFactory<PriamInstance> factory;
    private IMembership membership;
    private IConfiguration config;
    private Sleeper sleeper;
    private ITokenManager tokenManager;
    private ListMultimap<String, PriamInstance> locMap;

    @Inject
    public NewTokenRetriever(IPriamInstanceFactory factory, IMembership membership, IConfiguration config, Sleeper sleeper, ITokenManager tokenManager) {
        this.factory = factory;
        this.membership = membership;
        this.config = config;
        this.sleeper = sleeper;
        this.tokenManager = tokenManager;
    }

    @Override
    public PriamInstance get() throws Exception {
        int hash;
        logger.info("Generating my own and new token");
        this.sleeper.sleep(new Random().nextInt(15000));
        int max = hash = this.tokenManager.regionOffset(this.config.getDC());
        List<PriamInstance> allInstances = this.factory.getAllIds(this.config.getAppName());
        for (PriamInstance data : allInstances) {
            max = data.getRac().equals(this.config.getRac()) && data.getId() > max ? data.getId() : max;
        }
        int maxSlot = max - hash;
        int my_slot = 0;
        if (hash == max && this.locMap.get((Object)this.config.getRac()).size() == 0) {
            int idx = this.config.getRacs().indexOf(this.config.getRac());
            if (idx < 0) {
                throw new Exception(String.format("Rac %s is not in Racs %s", this.config.getRac(), this.config.getRacs()));
            }
            my_slot = idx + maxSlot;
        } else {
            my_slot = this.config.getRacs().size() + maxSlot;
        }
        logger.info("Trying to createToken with slot {} with rac count {} with rac membership size {} with dc {}", new Object[]{my_slot, this.membership.getRacCount(), this.membership.getRacMembershipSize(), this.config.getDC()});
        String payload = this.tokenManager.createToken(my_slot, this.membership.getRacCount(), this.membership.getRacMembershipSize(), this.config.getDC());
        return this.factory.create(this.config.getAppName(), my_slot + hash, this.config.getInstanceName(), this.config.getHostname(), this.config.getHostIP(), this.config.getRac(), null, payload);
    }

    @Override
    public void setLocMap(ListMultimap<String, PriamInstance> locMap) {
        this.locMap = locMap;
    }
}

