/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.resources;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.priam.PriamServer;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.restore.Restore;
import com.netflix.priam.tuner.ICassandraTuner;
import com.netflix.priam.utils.ITokenManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1")
@Produces(value={"application/json"})
public class RestoreServlet {
    private static final Logger logger = LoggerFactory.getLogger(RestoreServlet.class);
    private static final String REST_HEADER_RANGE = "daterange";
    private static final String REST_HEADER_REGION = "region";
    private static final String REST_HEADER_TOKEN = "token";
    private static final String REST_KEYSPACES = "keyspaces";
    private static final String REST_RESTORE_PREFIX = "restoreprefix";
    private static final String REST_SUCCESS = "[\"ok\"]";
    private IConfiguration config;
    private Restore restoreObj;
    private Provider<AbstractBackupPath> pathProvider;
    private PriamServer priamServer;
    private IPriamInstanceFactory factory;
    private ICassandraTuner tuner;
    private ICassandraProcess cassProcess;
    private ITokenManager tokenManager;
    private InstanceState instanceState;

    @Inject
    public RestoreServlet(IConfiguration config, Restore restoreObj, Provider<AbstractBackupPath> pathProvider, PriamServer priamServer, IPriamInstanceFactory factory, ICassandraTuner tuner, ICassandraProcess cassProcess, ITokenManager tokenManager, InstanceState instanceState) {
        this.config = config;
        this.restoreObj = restoreObj;
        this.pathProvider = pathProvider;
        this.priamServer = priamServer;
        this.factory = factory;
        this.tuner = tuner;
        this.cassProcess = cassProcess;
        this.tokenManager = tokenManager;
        this.instanceState = instanceState;
    }

    @GET
    @Path(value="/restore/status")
    public Response status() throws Exception {
        return Response.ok((Object)this.instanceState.getRestoreStatus().toString()).build();
    }

    @GET
    @Path(value="/restore")
    public Response restore(@QueryParam(value="daterange") String daterange, @QueryParam(value="region") String region, @QueryParam(value="token") String token, @QueryParam(value="keyspaces") String keyspaces, @QueryParam(value="restoreprefix") String restorePrefix) throws Exception {
        Date endTime;
        Date startTime;
        if (StringUtils.isBlank((CharSequence)daterange) || daterange.equalsIgnoreCase("default")) {
            startTime = new DateTime().minusDays(1).toDate();
            endTime = new DateTime().toDate();
        } else {
            String[] restore = daterange.split(",");
            AbstractBackupPath path = (AbstractBackupPath)this.pathProvider.get();
            startTime = path.parseDate(restore[0]);
            endTime = path.parseDate(restore[1]);
        }
        String origRestorePrefix = this.config.getRestorePrefix();
        if (StringUtils.isNotBlank((CharSequence)restorePrefix)) {
            this.config.setRestorePrefix(restorePrefix);
        }
        logger.info("Parameters: { token: [{}], region: [{}], startTime: [{}], endTime: [{}], keyspaces: [{}], restorePrefix: [{}]}", new Object[]{token, region, startTime, endTime, keyspaces, restorePrefix});
        this.restore(token, region, startTime, endTime, keyspaces);
        if (origRestorePrefix != null) {
            this.config.setRestorePrefix(origRestorePrefix);
        } else {
            this.config.setRestorePrefix("");
        }
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(String token, String region, Date startTime, Date endTime, String keyspaces) throws Exception {
        String origRegion = this.config.getDC();
        String origToken = this.priamServer.getId().getInstance().getToken();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.priamServer.getId().getInstance().setToken(token);
        }
        if (this.config.isRestoreClosestToken()) {
            this.priamServer.getId().getInstance().setToken(this.closestToken(this.priamServer.getId().getInstance().getToken(), this.config.getDC()));
        }
        if (StringUtils.isNotBlank((CharSequence)region)) {
            this.config.setDC(region);
            logger.info("Restoring from region {}", (Object)region);
            this.priamServer.getId().getInstance().setToken(this.closestToken(this.priamServer.getId().getInstance().getToken(), region));
            logger.info("Restore will use token {}", (Object)this.priamServer.getId().getInstance().getToken());
        }
        this.setRestoreKeyspaces(keyspaces);
        try {
            this.restoreObj.restore(startTime, endTime);
        }
        finally {
            this.config.setDC(origRegion);
            this.priamServer.getId().getInstance().setToken(origToken);
        }
        this.tuner.updateAutoBootstrap(this.config.getYamlLocation(), false);
        this.cassProcess.start(true);
    }

    private String closestToken(String token, String region) {
        List plist = this.factory.getAllIds(this.config.getAppName());
        ArrayList tokenList = Lists.newArrayList();
        for (PriamInstance ins : plist) {
            if (!ins.getDC().equalsIgnoreCase(region)) continue;
            tokenList.add(new BigInteger(ins.getToken()));
        }
        return this.tokenManager.findClosestToken(new BigInteger(token), tokenList).toString();
    }

    private void setRestoreKeyspaces(String keyspaces) {
        if (StringUtils.isNotBlank((CharSequence)keyspaces)) {
            ArrayList newKeyspaces = Lists.newArrayList((Object[])keyspaces.split(","));
            this.config.setRestoreKeySpaces(newKeyspaces);
        }
    }
}

