/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.restore;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.aws.S3CrossAccountFileSystem;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.MetaData;
import com.netflix.priam.compress.ICompression;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredentialGeneric;
import com.netflix.priam.cryptography.IFileCryptography;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.restore.EncryptedRestoreBase;
import com.netflix.priam.restore.IPostRestoreHook;
import com.netflix.priam.restore.RestoreTokenSelector;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.utils.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AwsCrossAccountCryptographyRestoreStrategy
extends EncryptedRestoreBase {
    private static final Logger logger = LoggerFactory.getLogger(AwsCrossAccountCryptographyRestoreStrategy.class);
    public static final String JOBNAME = "AWS_CROSS_ACCT_CRYPTOGRAPHY_RESTORE_JOB";

    @Inject
    public AwsCrossAccountCryptographyRestoreStrategy(IConfiguration config, ICassandraProcess cassProcess, S3CrossAccountFileSystem crossAcctfs, Sleeper sleeper, @Named(value="filecryptoalgorithm") IFileCryptography fileCryptography, @Named(value="pgpcredential") ICredentialGeneric credential, ICompression compress, Provider<AbstractBackupPath> pathProvider, InstanceIdentity id, RestoreTokenSelector tokenSelector, MetaData metaData, InstanceState instanceState, IPostRestoreHook postRestoreHook) {
        super(config, crossAcctfs.getBackupFileSystem(), JOBNAME, sleeper, cassProcess, pathProvider, id, tokenSelector, credential, fileCryptography, compress, metaData, instanceState, postRestoreHook);
    }

    public static TaskTimer getTimer() {
        return new SimpleTimer(JOBNAME);
    }
}

