/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.scheduler;

import com.netflix.priam.scheduler.TaskTimer;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronTimer
implements TaskTimer {
    private static final Logger logger = LoggerFactory.getLogger(CronTimer.class);
    private String cronExpression;
    private String name;

    public CronTimer(String name, int min) {
        this.name = name;
        this.cronExpression = "* 0/" + min + " * * * ?";
    }

    public CronTimer(String name, int minute, int sec) {
        this.name = name;
        this.cronExpression = sec + " " + minute + " 0/1 * * ?";
    }

    public CronTimer(String name, int hour, int minute, int sec) {
        this.name = name;
        this.cronExpression = sec + " " + minute + " " + hour + " * * ?";
    }

    public CronTimer(String name, DayOfWeek dayofweek, int hour, int minute, int sec) {
        this.name = name;
        this.cronExpression = sec + " " + minute + " " + hour + " * * " + (Object)((Object)dayofweek);
    }

    public CronTimer(String expression) {
        this.cronExpression = expression;
    }

    public CronTimer(String name, String expression) {
        this.name = name;
        this.cronExpression = expression;
    }

    @Override
    public Trigger getTrigger() throws ParseException {
        return TriggerBuilder.newTrigger().withIdentity(this.name, "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cronExpression)).build();
    }

    @Override
    public String getCronExpression() {
        return this.cronExpression;
    }

    public static CronTimer getCronTimer(String jobName, String cronExpression) throws IllegalArgumentException {
        CronTimer cronTimer = null;
        if (!StringUtils.isEmpty((CharSequence)cronExpression) && cronExpression.equalsIgnoreCase("-1")) {
            logger.info("Skipping {} as it is disabled via setting {} cron to -1.", (Object)jobName, (Object)jobName);
        } else {
            if (StringUtils.isEmpty((CharSequence)cronExpression) || !CronExpression.isValidExpression((String)cronExpression)) {
                throw new IllegalArgumentException("Invalid CRON expression: " + cronExpression + ". Please use -1, if you wish to disable " + jobName + " else fix the CRON expression and try again!");
            }
            cronTimer = new CronTimer(jobName, cronExpression);
            logger.info("Starting {} with CRON expression {}", (Object)jobName, (Object)cronTimer.getCronExpression());
        }
        return cronTimer;
    }

    public static enum DayOfWeek {
        SUN,
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT;

    }
}

