/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.scheduler;

import com.google.common.base.Throwables;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.scheduler.ExecutionException;
import com.netflix.priam.scheduler.TaskMBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task
implements Job,
TaskMBean {
    public STATE status = STATE.DONE;
    protected final IConfiguration config;
    private static final Logger logger = LoggerFactory.getLogger(Task.class);
    private final AtomicInteger errors = new AtomicInteger();
    private final AtomicInteger executions = new AtomicInteger();

    protected Task(IConfiguration config) {
        this(config, ManagementFactory.getPlatformMBeanServer());
    }

    protected Task(IConfiguration config, MBeanServer mBeanServer) {
        this.config = config;
        String mbeanName = "com.priam.scheduler:type=" + this.getClass().getName();
        try {
            mBeanServer.registerMBean(this, new ObjectName(mbeanName));
            this.initialize();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void initialize() throws ExecutionException {
    }

    public abstract void execute() throws Exception;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.executions.incrementAndGet();
        try {
            if (this.status == STATE.RUNNING) {
                return;
            }
            this.status = STATE.RUNNING;
            this.execute();
        }
        catch (Exception e) {
            this.status = STATE.ERROR;
            logger.error("Couldnt execute the task because of {}", (Object)e.getMessage(), (Object)e);
            this.errors.incrementAndGet();
        }
        catch (Throwable e) {
            this.status = STATE.ERROR;
            logger.error("Couldnt execute the task because of {}", (Object)e.getMessage(), (Object)e);
            this.errors.incrementAndGet();
        }
        if (this.status != STATE.ERROR) {
            this.status = STATE.DONE;
        }
    }

    public STATE state() {
        return this.status;
    }

    @Override
    public int getErrorCount() {
        return this.errors.get();
    }

    @Override
    public int getExecutionCount() {
        return this.executions.get();
    }

    @Override
    public abstract String getName();

    public static enum STATE {
        ERROR,
        RUNNING,
        DONE,
        NOT_APPLICABLE;

    }
}

