/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.tuner.JVMOptionsTuner;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileTuner {
    private static final Logger logger = LoggerFactory.getLogger(JVMOptionsTuner.class);
    protected final IConfiguration config;
    protected final String propertyPrefix;

    @Inject
    public PropertiesFileTuner(IConfiguration config, String prefix) {
        this.config = config;
        this.propertyPrefix = prefix;
    }

    public void updateAndSaveProperties(String configPath) throws IOException, ConfigurationException {
        File propertiesFile = new File(configPath);
        try {
            if (propertiesFile.exists() && !propertiesFile.canWrite()) {
                throw new IOException("Can't write and therefore cannot tune" + configPath);
            }
            PropertiesConfiguration properties = new PropertiesConfiguration();
            properties.getLayout().load(properties, (Reader)new FileReader(propertiesFile.getPath()));
            HashSet<String> keys = new HashSet<String>();
            properties.getKeys().forEachRemaining(keys::add);
            HashMap<String, String> overridenProperties = new HashMap<String, String>();
            String propertyOverrides = this.config.getProperty("propertyOverrides." + this.propertyPrefix, null);
            if (propertyOverrides != null) {
                String[] pairs;
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.convertValue((Object)this.config, Map.class);
                StrSubstitutor sub = new StrSubstitutor(map);
                String resolvedPropertyOverrides = sub.replace(propertyOverrides);
                for (String kv : pairs = resolvedPropertyOverrides.split(",")) {
                    String[] entry = kv.split("=");
                    if (entry.length != 2) continue;
                    keys.add(entry[0]);
                    overridenProperties.put(entry[0], entry[1]);
                }
            }
            for (String key : keys) {
                if (!overridenProperties.containsKey(key)) continue;
                properties.setProperty(key, overridenProperties.get(key));
            }
            properties.getLayout().save(properties, (Writer)new FileWriter(propertiesFile.getPath()));
        }
        catch (IOException | ConfigurationException e) {
            logger.error("Could not tune " + configPath, e);
            throw e;
        }
    }
}

