/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner.dse;

import java.util.Set;

public interface IDseConfiguration {
    public String getDseYamlLocation();

    public String getDseDelegatingSnitch();

    public NodeType getNodeType();

    public boolean isAuditLogEnabled();

    public String getAuditLogExemptKeyspaces();

    public Set<AuditLogCategory> getAuditLogCategories();

    public static enum AuditLogCategory {
        ADMIN,
        ALL,
        AUTH,
        DML,
        DDL,
        DCL,
        QUERY;

    }

    public static enum NodeType {
        REAL_TIME_QUERY("cassandra"),
        ANALYTIC_HADOOP("hadoop"),
        ANALYTIC_SPARK("spark"),
        ANALYTIC_HADOOP_SPARK("hadoop-spark"),
        SEARCH("solr");

        private final String altName;

        private NodeType(String altName) {
            this.altName = altName;
        }

        public static NodeType getByAltName(String altName) {
            for (NodeType nt : NodeType.values()) {
                if (!nt.altName.toLowerCase().equals(altName)) continue;
                return nt;
            }
            throw new IllegalArgumentException("Unknown node type: " + altName);
        }
    }
}

