/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.netflix.priam.utils.JMXNodeTool;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.List;
import javax.management.remote.JMXConnector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);

    public static String getDataFromUrl(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(1000);
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Unable to get data for URL " + url);
            }
            byte[] b = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataInputStream d = new DataInputStream((FilterInputStream)conn.getContent());
            int c = 0;
            while ((c = d.read(b, 0, b.length)) != -1) {
                bos.write(b, 0, c);
            }
            String return_ = new String(bos.toByteArray(), Charsets.UTF_8);
            logger.info("Calling URL API: {} returns: {}", (Object)url, (Object)return_);
            conn.disconnect();
            return return_;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void cleanupDir(String dirPath, List<String> childdirs) throws IOException {
        if (childdirs == null || childdirs.size() == 0) {
            FileUtils.cleanDirectory((File)new File(dirPath));
        } else {
            for (String cdir : childdirs) {
                FileUtils.cleanDirectory((File)new File(dirPath + "/" + cdir));
            }
        }
    }

    public static void createDirs(String location) {
        File dirFile = new File(location);
        if (dirFile.exists() && dirFile.isFile()) {
            dirFile.delete();
            dirFile.mkdirs();
        } else if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
    }

    public static byte[] md5(byte[] buf) {
        try {
            MessageDigest mdigest = MessageDigest.getInstance("MD5");
            mdigest.update(buf, 0, buf.length);
            return mdigest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5(File file) {
        try {
            HashCode hc = Files.hash((File)file, (HashFunction)Hashing.md5());
            return SystemUtils.toHex(hc.asBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toHex(byte[] digest) {
        StringBuffer sb = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(digest[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase();
    }

    public static String toBase64(byte[] md5) {
        byte[] encoded = Base64.encodeBase64((byte[])md5, (boolean)false);
        return new String(encoded);
    }

    public static void closeQuietly(JMXNodeTool tool) {
        try {
            tool.close();
        }
        catch (Exception e) {
            logger.warn("failed to close jxm node tool", (Throwable)e);
        }
    }

    public static void closeQuietly(JMXConnector jmc) {
        try {
            jmc.close();
        }
        catch (Exception e) {
            logger.warn("failed to close JMXConnectorMgr", (Throwable)e);
        }
    }

    public static BufferedReader readFile(String absPathToFile) throws IOException {
        FileInputStream is = new FileInputStream(absPathToFile);
        InputStreamReader isr = new InputStreamReader(is);
        return new BufferedReader(isr);
    }

    public static void writeToFile(String filename, String line) {
        File f = new File(filename);
        PrintWriter pw = null;
        FileWriter fw = null;
        try {
            if (!f.exists()) {
                f.createNewFile();
                logger.info("File created, absolute path: {}", (Object)f.getAbsolutePath());
            }
            fw = new FileWriter(f, false);
            pw = new PrintWriter(fw);
            pw.print(line);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception processing file: " + filename, e);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }
}

