/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.utils.ITokenManager;
import java.math.BigInteger;
import java.util.List;

public class TokenManager
implements ITokenManager {
    public static final BigInteger MINIMUM_TOKEN_RANDOM = BigInteger.ZERO;
    public static final BigInteger MAXIMUM_TOKEN_RANDOM = new BigInteger("2").pow(127);
    public static final BigInteger MINIMUM_TOKEN_MURMUR3 = new BigInteger("-2").pow(63);
    public static final BigInteger MAXIMUM_TOKEN_MURMUR3 = new BigInteger("2").pow(63);
    private final BigInteger minimumToken;
    private final BigInteger maximumToken;
    private final BigInteger tokenRangeSize;
    private IConfiguration config;

    @Inject
    public TokenManager(IConfiguration config) {
        this.config = config;
        if ("org.apache.cassandra.dht.Murmur3Partitioner".equals(this.config.getPartitioner())) {
            this.minimumToken = MINIMUM_TOKEN_MURMUR3;
            this.maximumToken = MAXIMUM_TOKEN_MURMUR3;
        } else {
            this.minimumToken = MINIMUM_TOKEN_RANDOM;
            this.maximumToken = MAXIMUM_TOKEN_RANDOM;
        }
        this.tokenRangeSize = this.maximumToken.subtract(this.minimumToken);
    }

    @VisibleForTesting
    BigInteger initialToken(int size, int position, int offset) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"size must be > 0");
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must be >= 0");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        return this.tokenRangeSize.divide(BigInteger.valueOf(size)).multiply(BigInteger.valueOf(position)).add(BigInteger.valueOf(offset)).add(this.minimumToken);
    }

    @Override
    public String createToken(int my_slot, int rac_count, int rac_size, String region) {
        int regionCount = rac_count * rac_size;
        return this.initialToken(regionCount, my_slot, this.regionOffset(region)).toString();
    }

    @Override
    public String createToken(int my_slot, int totalCount, String region) {
        return this.initialToken(totalCount, my_slot, this.regionOffset(region)).toString();
    }

    @Override
    public BigInteger findClosestToken(BigInteger tokenToSearch, List<BigInteger> tokenList) {
        Preconditions.checkArgument((!tokenList.isEmpty() ? 1 : 0) != 0, (Object)"token list must not be empty");
        List sortedTokens = Ordering.natural().sortedCopy(tokenList);
        int index = Ordering.natural().binarySearch(sortedTokens, (Object)tokenToSearch);
        if (index < 0) {
            int i = Math.abs(index) - 1;
            if (i >= sortedTokens.size() || i > 0 && ((BigInteger)sortedTokens.get(i)).subtract(tokenToSearch).compareTo(tokenToSearch.subtract((BigInteger)sortedTokens.get(i - 1))) > 0) {
                --i;
            }
            return (BigInteger)sortedTokens.get(i);
        }
        return (BigInteger)sortedTokens.get(index);
    }

    @Override
    public int regionOffset(String region) {
        return Math.abs(region.hashCode());
    }
}

