/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.InstanceIdentity;
import java.util.ArrayList;
import java.util.Date;

public class S3BackupPath
extends AbstractBackupPath {
    private static final int NUM_PATH_ELEMENTS_CASS_1_0 = 8;

    @Inject
    public S3BackupPath(IConfiguration config, InstanceIdentity factory) {
        super(config, factory);
    }

    @Override
    public String getRemotePath() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.baseDir).append(PATH_SEP);
        buff.append(this.region).append(PATH_SEP);
        buff.append(this.clusterName).append(PATH_SEP);
        buff.append(this.token).append(PATH_SEP);
        buff.append(S3BackupPath.formatDate(this.time)).append(PATH_SEP);
        buff.append((Object)this.type).append(PATH_SEP);
        if (AbstractBackupPath.BackupFileType.isDataFile(this.type)) {
            if (this.isCassandra1_0) {
                buff.append(this.keyspace).append(PATH_SEP);
            } else {
                buff.append(this.keyspace).append(PATH_SEP).append(this.columnFamily).append(PATH_SEP);
            }
        }
        buff.append(this.fileName);
        return buff.toString();
    }

    @Override
    public void parseRemote(String remoteFilePath) {
        String[] elements = remoteFilePath.split(String.valueOf(PATH_SEP));
        ArrayList pieces = Lists.newArrayList();
        for (String ele : elements) {
            if (ele.equals("")) continue;
            pieces.add(ele);
        }
        assert (pieces.size() >= 7) : "Too few elements in path " + remoteFilePath;
        if (pieces.size() == 8) {
            this.setCassandra1_0(true);
        }
        this.baseDir = (String)pieces.get(0);
        this.region = (String)pieces.get(1);
        this.clusterName = (String)pieces.get(2);
        this.token = (String)pieces.get(3);
        this.time = this.parseDate((String)pieces.get(4));
        this.type = AbstractBackupPath.BackupFileType.valueOf((String)pieces.get(5));
        if (AbstractBackupPath.BackupFileType.isDataFile(this.type)) {
            this.keyspace = (String)pieces.get(6);
            if (!this.isCassandra1_0) {
                this.columnFamily = (String)pieces.get(7);
            }
        }
        this.fileName = (String)pieces.get(pieces.size() - 1);
    }

    @Override
    public void parsePartialPrefix(String remoteFilePath) {
        String[] elements = remoteFilePath.split(String.valueOf(PATH_SEP));
        ArrayList pieces = Lists.newArrayList();
        for (String ele : elements) {
            if (ele.equals("")) continue;
            pieces.add(ele);
        }
        assert (pieces.size() >= 4) : "Too few elements in path " + remoteFilePath;
        this.baseDir = (String)pieces.get(0);
        this.region = (String)pieces.get(1);
        this.clusterName = (String)pieces.get(2);
        this.token = (String)pieces.get(3);
    }

    @Override
    public String remotePrefix(Date start, Date end, String location) {
        StringBuffer buff = new StringBuffer(this.clusterPrefix(location));
        this.token = this.factory.getInstance().getToken();
        buff.append(this.token).append(PATH_SEP);
        buff.append(this.match(start, end));
        return buff.toString();
    }

    @Override
    public String clusterPrefix(String location) {
        StringBuffer buff = new StringBuffer();
        String[] elements = location.split(String.valueOf(PATH_SEP));
        if (elements.length <= 1) {
            this.baseDir = this.config.getBackupLocation();
            this.region = this.config.getDC();
            this.clusterName = this.config.getAppName();
        } else {
            assert (elements.length >= 4) : "Too few elements in path " + location;
            this.baseDir = elements[1];
            this.region = elements[2];
            this.clusterName = elements[3];
        }
        buff.append(this.baseDir).append(PATH_SEP);
        buff.append(this.region).append(PATH_SEP);
        buff.append(this.clusterName).append(PATH_SEP);
        return buff.toString();
    }
}

