/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.aws.S3FileSystem;
import com.netflix.priam.aws.auth.IS3Credential;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.config.IConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class S3CrossAccountFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(S3CrossAccountFileSystem.class);
    private AmazonS3 s3Client;
    private S3FileSystem s3fs;
    private IConfiguration config;
    private IS3Credential s3Credential;

    @Inject
    public S3CrossAccountFileSystem(@Named(value="backup") IBackupFileSystem fs, @Named(value="awss3roleassumption") IS3Credential s3Credential, IConfiguration config) {
        this.s3fs = (S3FileSystem)fs;
        this.config = config;
        this.s3Credential = s3Credential;
    }

    public IBackupFileSystem getBackupFileSystem() {
        return this.s3fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3 getCrossAcctS3Client() {
        if (this.s3Client == null) {
            S3CrossAccountFileSystem s3CrossAccountFileSystem = this;
            synchronized (s3CrossAccountFileSystem) {
                if (this.s3Client == null) {
                    try {
                        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(this.s3Credential.getAwsCredentialProvider())).withRegion(this.config.getDC())).build();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Exception in getting handle to s3 client.  Msg: " + e.getLocalizedMessage(), e);
                    }
                    this.s3fs.setS3Client(this.s3Client);
                }
            }
        }
        return this.s3Client;
    }
}

