/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.AmazonServiceException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.aws.SDBInstanceData;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SDBInstanceFactory
implements IPriamInstanceFactory<PriamInstance> {
    private static final Logger logger = LoggerFactory.getLogger(SDBInstanceFactory.class);
    private final IConfiguration config;
    private final SDBInstanceData dao;

    @Inject
    public SDBInstanceFactory(IConfiguration config, SDBInstanceData dao) {
        this.config = config;
        this.dao = dao;
    }

    @Override
    public List<PriamInstance> getAllIds(String appName) {
        ArrayList<PriamInstance> return_ = new ArrayList<PriamInstance>();
        for (PriamInstance instance : this.dao.getAllIds(appName)) {
            return_.add(instance);
        }
        this.sort((List<PriamInstance>)return_);
        return return_;
    }

    @Override
    public PriamInstance getInstance(String appName, String dc, int id) {
        return this.dao.getInstance(appName, dc, id);
    }

    @Override
    public PriamInstance create(String app, int id, String instanceID, String hostname, String ip, String rac, Map<String, Object> volumes, String token) {
        try {
            PriamInstance ins = this.makePriamInstance(app, id, instanceID, hostname, ip, rac, volumes, token);
            if (app.endsWith("-dead")) {
                try {
                    PriamInstance oldData = this.dao.getInstance(app, this.config.getDC(), id);
                    if (null != oldData && oldData.getUpdatetime() < System.currentTimeMillis() - 180000L) {
                        this.dao.deregisterInstance(oldData);
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            this.dao.registerInstance(ins);
            return ins;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(PriamInstance inst) {
        try {
            this.dao.deregisterInstance(inst);
        }
        catch (AmazonServiceException e) {
            throw new RuntimeException("Unable to deregister priam instance", e);
        }
    }

    @Override
    public void update(PriamInstance inst) {
        try {
            this.dao.createInstance(inst);
        }
        catch (AmazonServiceException e) {
            throw new RuntimeException("Unable to update/create priam instance", e);
        }
    }

    @Override
    public void sort(List<PriamInstance> return_) {
        Comparator<PriamInstance> comparator = new Comparator<PriamInstance>(){

            @Override
            public int compare(PriamInstance o1, PriamInstance o2) {
                Integer c1 = o1.getId();
                Integer c2 = o2.getId();
                return c1.compareTo(c2);
            }
        };
        Collections.sort(return_, comparator);
    }

    @Override
    public void attachVolumes(PriamInstance instance, String mountPath, String device) {
    }

    private PriamInstance makePriamInstance(String app, int id, String instanceID, String hostname, String ip, String rac, Map<String, Object> volumes, String token) {
        HashMap<String, Object> v = volumes == null ? new HashMap<String, Object>() : volumes;
        PriamInstance ins = new PriamInstance();
        ins.setApp(app);
        ins.setRac(rac);
        ins.setHost(hostname);
        ins.setHostIP(ip);
        ins.setId(id);
        ins.setInstanceId(instanceID);
        ins.setDC(this.config.getDC());
        ins.setToken(token);
        ins.setVolumes(v);
        return ins;
    }
}

