/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.ImplementedBy;
import com.netflix.priam.aws.S3BackupPath;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.InstanceIdentity;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementedBy(value=S3BackupPath.class)
public abstract class AbstractBackupPath
implements Comparable<AbstractBackupPath> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBackupPath.class);
    private static final String FMT = "yyyyMMddHHmm";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
    public static final char PATH_SEP = File.separatorChar;
    protected BackupFileType type;
    protected String clusterName;
    protected String keyspace;
    protected String columnFamily;
    protected String fileName;
    protected String baseDir;
    protected String token;
    protected String region;
    protected Date time;
    protected long size;
    protected long compressedFileSize = 0L;
    protected boolean isCassandra1_0;
    protected final InstanceIdentity factory;
    protected final IConfiguration config;
    protected File backupFile;
    protected Date uploadedTs;

    public AbstractBackupPath(IConfiguration config, InstanceIdentity factory) {
        this.factory = factory;
        this.config = config;
    }

    public static String formatDate(Date d) {
        return new DateTime((Object)d).toString(FMT);
    }

    public Date parseDate(String s) {
        return DATE_FORMAT.parseDateTime(s).toDate();
    }

    public InputStream localReader() throws IOException {
        assert (this.backupFile != null);
        return new RafInputStream(new RandomAccessFile(this.backupFile, "r"));
    }

    public void parseLocal(File file, BackupFileType type) throws ParseException {
        this.backupFile = file;
        String rpath = new File(this.config.getDataFileLocation()).toURI().relativize(file.toURI()).getPath();
        String[] elements = rpath.split("" + PATH_SEP);
        this.clusterName = this.config.getAppName();
        this.baseDir = this.config.getBackupLocation();
        this.region = this.config.getDC();
        this.token = this.factory.getInstance().getToken();
        this.type = type;
        if (BackupFileType.isDataFile(type)) {
            this.keyspace = elements[0];
            if (!this.isCassandra1_0) {
                this.columnFamily = elements[1];
            }
        }
        if (type == BackupFileType.SNAP) {
            this.time = this.parseDate(elements[3]);
        }
        if (type == BackupFileType.SST || type == BackupFileType.CL) {
            this.time = new Date(file.lastModified());
        }
        this.fileName = file.getName();
        this.size = file.length();
    }

    public String match(Date start, Date end) {
        String eString;
        String sString = AbstractBackupPath.formatDate(start);
        int diff = StringUtils.indexOfDifference((CharSequence)sString, (CharSequence)(eString = AbstractBackupPath.formatDate(end)));
        if (diff < 0) {
            return sString;
        }
        return sString.substring(0, diff);
    }

    public File newRestoreFile() {
        StringBuffer buff = new StringBuffer();
        if (this.type == BackupFileType.CL) {
            buff.append(this.config.getBackupCommitLogLocation()).append(PATH_SEP);
        } else {
            buff.append(this.config.getDataFileLocation()).append(PATH_SEP);
            if (this.type != BackupFileType.META && this.type != BackupFileType.META_V2) {
                if (this.isCassandra1_0) {
                    buff.append(this.keyspace).append(PATH_SEP);
                } else {
                    buff.append(this.keyspace).append(PATH_SEP).append(this.columnFamily).append(PATH_SEP);
                }
            }
        }
        buff.append(this.fileName);
        File return_ = new File(buff.toString());
        File parent = new File(return_.getParent());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return return_;
    }

    @Override
    public int compareTo(AbstractBackupPath o) {
        return this.getRemotePath().compareTo(o.getRemotePath());
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.getRemotePath().equals(((AbstractBackupPath)obj).getRemotePath());
    }

    public abstract String getRemotePath();

    public abstract void parseRemote(String var1);

    public abstract void parsePartialPrefix(String var1);

    public abstract String remotePrefix(Date var1, Date var2, String var3);

    public abstract String clusterPrefix(String var1);

    public BackupFileType getType() {
        return this.type;
    }

    public void setType(BackupFileType type) {
        this.type = type;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getToken() {
        return this.token;
    }

    public String getRegion() {
        return this.region;
    }

    public Date getTime() {
        return this.time;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getCompressedFileSize() {
        return this.compressedFileSize;
    }

    public void setCompressedFileSize(long val) {
        this.compressedFileSize = val;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public boolean isCassandra1_0() {
        return this.isCassandra1_0;
    }

    public void setCassandra1_0(boolean isCassandra1_0) {
        this.isCassandra1_0 = isCassandra1_0;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public InstanceIdentity getInstanceIdentity() {
        return this.factory;
    }

    public void setUploadedTs(Date uploadedTs) {
        this.uploadedTs = uploadedTs;
    }

    public Date getUploadedTs() {
        return this.uploadedTs;
    }

    public String toString() {
        return "From: " + this.getRemotePath() + " To: " + this.newRestoreFile().getPath();
    }

    public static class RafInputStream
    extends InputStream {
        private RandomAccessFile raf;

        public RafInputStream(RandomAccessFile raf) {
            this.raf = raf;
        }

        @Override
        public synchronized int read(byte[] bytes, int off, int len) throws IOException {
            return this.raf.read(bytes, off, len);
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((Closeable)this.raf);
        }

        @Override
        public int read() throws IOException {
            return 0;
        }
    }

    public static enum BackupFileType {
        SNAP,
        SST,
        CL,
        META,
        META_V2;


        public static boolean isDataFile(BackupFileType type) {
            return type != META && type != META_V2 && type != CL;
        }
    }
}

