/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.backup.BackupMetadata;
import com.netflix.priam.backup.IBackupStatusMgr;
import com.netflix.priam.backup.Status;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.utils.DateUtil;
import com.netflix.priam.utils.MaxSizeHashMap;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class BackupStatusMgr
implements IBackupStatusMgr {
    private static final Logger logger = LoggerFactory.getLogger(BackupStatusMgr.class);
    Map<String, LinkedList<BackupMetadata>> backupMetadataMap;
    int capacity;
    private InstanceState instanceState;

    @Inject
    public BackupStatusMgr(int capacity, InstanceState instanceState) {
        this.capacity = capacity;
        this.instanceState = instanceState;
        this.backupMetadataMap = new MaxSizeHashMap<String, LinkedList<BackupMetadata>>(capacity);
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public Map<String, LinkedList<BackupMetadata>> getAllSnapshotStatus() {
        return this.backupMetadataMap;
    }

    public LinkedList<BackupMetadata> locate(Date snapshotDate) {
        return this.locate(DateUtil.formatyyyyMMdd(snapshotDate));
    }

    public LinkedList<BackupMetadata> locate(String snapshotDate) {
        if (StringUtils.isEmpty((CharSequence)snapshotDate)) {
            return null;
        }
        if (this.backupMetadataMap.containsKey(snapshotDate)) {
            return this.backupMetadataMap.get(snapshotDate);
        }
        LinkedList<BackupMetadata> metadataLinkedList = this.fetch(snapshotDate);
        this.backupMetadataMap.put(snapshotDate, metadataLinkedList);
        return metadataLinkedList;
    }

    @Override
    public void start(BackupMetadata backupMetadata) {
        LinkedList<BackupMetadata> metadataLinkedList = this.locate(backupMetadata.getSnapshotDate());
        if (metadataLinkedList == null) {
            metadataLinkedList = new LinkedList<BackupMetadata>();
        }
        metadataLinkedList.addFirst(backupMetadata);
        this.backupMetadataMap.put(backupMetadata.getSnapshotDate(), metadataLinkedList);
        this.instanceState.setBackupStatus(backupMetadata);
        this.save(backupMetadata);
    }

    @Override
    public void finish(BackupMetadata backupMetadata) {
        if (backupMetadata.getStatus() != Status.FINISHED) {
            backupMetadata.setStatus(Status.FINISHED);
        }
        if (backupMetadata.getCompleted() == null) {
            backupMetadata.setCompleted(Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime());
        }
        this.instanceState.setBackupStatus(backupMetadata);
        this.retrieveAndUpdate(backupMetadata);
        this.save(backupMetadata);
    }

    private void retrieveAndUpdate(BackupMetadata backupMetadata) {
        LinkedList<BackupMetadata> metadataLinkedList = this.locate(backupMetadata.getSnapshotDate());
        if (metadataLinkedList == null || metadataLinkedList.isEmpty()) {
            logger.error("No previous backupMetaData found. This should not happen. Creating new to ensure app keeps running.");
            metadataLinkedList = new LinkedList<BackupMetadata>();
            metadataLinkedList.addFirst(backupMetadata);
        }
        metadataLinkedList.forEach(backupMetadata1 -> {
            if (backupMetadata1.equals(backupMetadata)) {
                backupMetadata1.setCompleted(backupMetadata.getCompleted());
                backupMetadata1.setStatus(backupMetadata.getStatus());
            }
        });
    }

    @Override
    public void failed(BackupMetadata backupMetadata) {
        if (backupMetadata.getCompleted() == null) {
            backupMetadata.setCompleted(Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime());
        }
        if (backupMetadata.getStatus() != Status.FAILED) {
            backupMetadata.setStatus(Status.FAILED);
        }
        this.instanceState.setBackupStatus(backupMetadata);
        this.retrieveAndUpdate(backupMetadata);
        this.save(backupMetadata);
    }

    protected abstract void save(BackupMetadata var1);

    protected abstract LinkedList<BackupMetadata> fetch(String var1);

    public String toString() {
        StringBuffer sb = new StringBuffer("BackupStatusMgr{");
        sb.append("backupMetadataMap=").append(this.backupMetadataMap);
        sb.append(", capacity=").append(this.capacity);
        sb.append('}');
        return sb.toString();
    }
}

