/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backupv2;

import com.netflix.priam.config.IConfiguration;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFileManager {
    private static final Logger logger = LoggerFactory.getLogger(MetaFileManager.class);
    private final Path metaFileDirectory;

    @Inject
    MetaFileManager(IConfiguration configuration) {
        this.metaFileDirectory = Paths.get(configuration.getDataFileLocation(), new String[0]);
    }

    public Path getMetaFileDirectory() {
        return this.metaFileDirectory;
    }

    public void cleanupOldMetaFiles() {
        logger.info("Deleting any old META_V2 files if any");
        IOFileFilter fileNameFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)"meta_v2_"), FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".json"), FileFilterUtils.suffixFileFilter((String)".json.tmp")})});
        Collection files = FileUtils.listFiles((File)this.metaFileDirectory.toFile(), (IOFileFilter)fileNameFilter, null);
        files.stream().filter(file -> file.isFile()).forEach(file -> {
            logger.debug("Deleting old META_V2 file found: {}", (Object)file.getAbsolutePath());
            file.delete();
        });
    }
}

