/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backupv2;

import com.google.gson.stream.JsonReader;
import com.netflix.priam.backupv2.ColumnfamilyResult;
import com.netflix.priam.backupv2.MetaFileInfo;
import com.netflix.priam.utils.DateUtil;
import com.netflix.priam.utils.GsonJsonSerializer;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetaFileReader {
    private static final Logger logger = LoggerFactory.getLogger(MetaFileReader.class);
    private JsonReader jsonReader;
    private MetaFileInfo metaFileInfo;

    public MetaFileInfo getMetaFileInfo() {
        return this.metaFileInfo;
    }

    public void readMeta(Path metaFilePath) throws IOException {
        if (!(metaFilePath != null && metaFilePath.toFile().exists() && metaFilePath.toFile().isFile() && this.isValidMetaFile(metaFilePath))) {
            throw new FileNotFoundException("MetaFilePath: " + metaFilePath + " do not exist or is not valid meta file.");
        }
        logger.info("Trying to read the meta file: {}", (Object)metaFilePath);
        this.jsonReader = new JsonReader((Reader)new FileReader(metaFilePath.toFile()));
        this.jsonReader.beginObject();
        while (this.jsonReader.hasNext()) {
            switch (this.jsonReader.nextName()) {
                case "info": {
                    this.metaFileInfo = (MetaFileInfo)GsonJsonSerializer.getGson().fromJson(this.jsonReader, MetaFileInfo.class);
                    break;
                }
                case "data": {
                    this.jsonReader.beginArray();
                    while (this.jsonReader.hasNext()) {
                        this.process((ColumnfamilyResult)GsonJsonSerializer.getGson().fromJson(this.jsonReader, ColumnfamilyResult.class));
                    }
                    this.jsonReader.endArray();
                }
            }
        }
        this.jsonReader.endObject();
        this.jsonReader.close();
        logger.info("Finished reading the meta file: {}", (Object)metaFilePath);
    }

    public abstract void process(ColumnfamilyResult var1);

    public boolean isValidMetaFile(Path metaFilePath) {
        String fileName = metaFilePath.toFile().getName();
        if (fileName.startsWith("meta_v2_") && fileName.endsWith(".json")) {
            String dateString = fileName.substring("meta_v2_".length(), fileName.length() - ".json".length());
            DateUtil.parseInstant(dateString);
            return true;
        }
        return false;
    }
}

