/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backupv2;

import com.google.gson.stream.JsonWriter;
import com.google.inject.Provider;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backupv2.ColumnfamilyResult;
import com.netflix.priam.backupv2.MetaFileInfo;
import com.netflix.priam.backupv2.MetaFileManager;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.utils.RetryableCallable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFileWriterBuilder {
    private MetaFileWriter metaFileWriter;
    private static final Logger logger = LoggerFactory.getLogger(MetaFileWriterBuilder.class);

    @Inject
    MetaFileWriterBuilder(MetaFileWriter metaFileWriter) {
        this.metaFileWriter = metaFileWriter;
    }

    public StartStep newBuilder() throws IOException {
        return this.metaFileWriter;
    }

    public static class MetaFileWriter
    implements StartStep,
    DataStep,
    UploadStep {
        private final Provider<AbstractBackupPath> pathFactory;
        private final IBackupFileSystem backupFileSystem;
        private MetaFileInfo metaFileInfo;
        private MetaFileManager metaFileManager;
        private JsonWriter jsonWriter;
        private Path metaFilePath;

        @Inject
        private MetaFileWriter(IConfiguration configuration, InstanceIdentity instanceIdentity, Provider<AbstractBackupPath> pathFactory, IFileSystemContext backupFileSystemCtx, MetaFileManager metaFileManager) {
            this.pathFactory = pathFactory;
            this.backupFileSystem = backupFileSystemCtx.getFileStrategy(configuration);
            this.metaFileManager = metaFileManager;
            ArrayList<String> backupIdentifier = new ArrayList<String>();
            backupIdentifier.add(instanceIdentity.getInstance().getToken());
            this.metaFileInfo = new MetaFileInfo(configuration.getAppName(), configuration.getDC(), configuration.getRac(), backupIdentifier);
        }

        @Override
        public DataStep startMetaFileGeneration(Instant snapshotInstant) throws IOException {
            String fileName = MetaFileInfo.getMetaFileName(snapshotInstant);
            this.metaFilePath = Paths.get(this.metaFileManager.getMetaFileDirectory().toString(), fileName);
            Path tempMetaFilePath = Paths.get(this.metaFileManager.getMetaFileDirectory().toString(), fileName + ".tmp");
            logger.info("Starting to write a new meta file: {}", (Object)this.metaFilePath);
            this.jsonWriter = new JsonWriter((Writer)new FileWriter(tempMetaFilePath.toFile()));
            this.jsonWriter.beginObject();
            this.jsonWriter.name("info");
            this.jsonWriter.jsonValue(this.metaFileInfo.toString());
            this.jsonWriter.name("data");
            this.jsonWriter.beginArray();
            return this;
        }

        @Override
        public DataStep addColumnfamilyResult(ColumnfamilyResult columnfamilyResult) throws IOException {
            if (this.jsonWriter == null) {
                throw new NullPointerException("addColumnfamilyResult: Json Writer in MetaFileWriter is null. This should not happen!");
            }
            if (columnfamilyResult == null) {
                throw new NullPointerException("Column family result is null in MetaFileWriter. This should not happen!");
            }
            this.jsonWriter.jsonValue(columnfamilyResult.toString());
            return this;
        }

        @Override
        public UploadStep endMetaFileGeneration() throws IOException {
            if (this.jsonWriter == null) {
                throw new NullPointerException("endMetaFileGeneration: Json Writer in MetaFileWriter is null. This should not happen!");
            }
            this.jsonWriter.endArray();
            this.jsonWriter.endObject();
            this.jsonWriter.close();
            Path tempMetaFilePath = Paths.get(this.metaFileManager.getMetaFileDirectory().toString(), this.metaFilePath.toFile().getName() + ".tmp");
            tempMetaFilePath.toFile().renameTo(this.metaFilePath.toFile());
            logger.info("Finished writing to meta file: {}", (Object)this.metaFilePath);
            return this;
        }

        @Override
        public void uploadMetaFile(boolean deleteOnSuccess) throws Exception {
            final AbstractBackupPath abstractBackupPath = (AbstractBackupPath)this.pathFactory.get();
            abstractBackupPath.parseLocal(this.metaFilePath.toFile(), AbstractBackupPath.BackupFileType.META_V2);
            new RetryableCallable<Void>(6, 5000L){

                @Override
                public Void retriableCall() throws Exception {
                    backupFileSystem.upload(abstractBackupPath, abstractBackupPath.localReader());
                    abstractBackupPath.setCompressedFileSize(backupFileSystem.getBytesUploaded());
                    return null;
                }
            }.call();
            if (deleteOnSuccess) {
                FileUtils.deleteQuietly((File)this.metaFilePath.toFile());
            }
        }

        @Override
        public Path getMetaFilePath() {
            return this.metaFilePath;
        }
    }

    public static interface UploadStep {
        public void uploadMetaFile(boolean var1) throws Exception;

        public Path getMetaFilePath();
    }

    public static interface DataStep {
        public DataStep addColumnfamilyResult(ColumnfamilyResult var1) throws IOException;

        public UploadStep endMetaFileGeneration() throws IOException;
    }

    public static interface StartStep {
        public DataStep startMetaFileGeneration(Instant var1) throws IOException;
    }
}

