/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backupv2;

import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.utils.DateUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import javax.inject.Inject;

public class PrefixGenerator {
    private IConfiguration configuration;
    private InstanceIdentity instanceIdentity;

    @Inject
    PrefixGenerator(IConfiguration configuration, InstanceIdentity instanceIdentity) {
        this.configuration = configuration;
        this.instanceIdentity = instanceIdentity;
    }

    public Path getPrefix() {
        return Paths.get(this.configuration.getBackupLocation(), this.configuration.getBackupPrefix(), this.getAppNameReverse(), this.instanceIdentity.getInstance().getToken());
    }

    public Path getSSTPrefix() {
        return this.getPrefix();
    }

    public Path getSSTLocation(Instant instant, String keyspaceName, String columnfamilyName, String prefix, String fileName) {
        return Paths.get(this.getPrefix().toString(), DateUtil.formatInstant("ddMMyyyyHHmm", instant), keyspaceName, columnfamilyName, prefix, fileName);
    }

    public Path getMetaPrefix() {
        return Paths.get(this.getPrefix().toString(), "META");
    }

    public Path getMetaLocation(Instant instant, String metaFileName) {
        return Paths.get(this.getMetaPrefix().toString(), DateUtil.formatInstant("ddMMyyyyHHmm", instant), metaFileName);
    }

    private String getAppNameReverse() {
        return new StringBuilder(this.configuration.getAppName()).reverse().toString();
    }

    public static final String getSSTFileBase(String fileName) {
        String prefix = null;
        try {
            prefix = fileName.substring(0, fileName.lastIndexOf("-"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return prefix;
    }
}

