/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.cli;

import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.cli.Application;
import com.netflix.priam.restore.Restore;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Restorer {
    private static final Logger logger = LoggerFactory.getLogger(Restorer.class);

    static void displayHelp() {
        System.out.println("Usage: command_name FROM_DATE TO_DATE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Application.initialize();
            if (args.length < 2) {
                Restorer.displayHelp();
                return;
            }
            AbstractBackupPath path = (AbstractBackupPath)Application.getInjector().getInstance(AbstractBackupPath.class);
            Date startTime = path.parseDate(args[0]);
            Date endTime = path.parseDate(args[1]);
            Restore restorer = (Restore)Application.getInjector().getInstance(Restore.class);
            try {
                restorer.restore(startTime, endTime);
            }
            catch (Exception e) {
                logger.error("Unable to restore: ", (Throwable)e);
            }
        }
        finally {
            Application.shutdownAdditionalThreads();
        }
    }
}

