/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.cli;

import com.netflix.priam.identity.IMembership;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMembership
implements IMembership {
    private static final String MEMBERSHIP_PRE = "membership.";
    private static final String INSTANCES_PRE = "membership.instances.";
    private static final String RAC_NAME = "membership.racname";
    private static final String DEFAULT_PROP_PATH = "/etc/priam/membership.properties";
    private static final Logger logger = LoggerFactory.getLogger(StaticMembership.class);
    private List<String> racMembership;
    private int racCount;

    public StaticMembership() throws IOException {
        Properties config = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(DEFAULT_PROP_PATH);
            config.load(fis);
        }
        catch (Exception e) {
            try {
                logger.error("Exception with static membership file ", (Throwable)e);
                throw new RuntimeException("Problem reading static membership file. Cannot start.", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        FileUtils.closeQuietly((Closeable)fis);
        String racName = config.getProperty(RAC_NAME);
        this.racCount = 0;
        for (String name : config.stringPropertyNames()) {
            if (!name.startsWith(INSTANCES_PRE)) continue;
            ++this.racCount;
            if (name != INSTANCES_PRE + racName) continue;
            this.racMembership = Arrays.asList(config.getProperty(name).split(","));
        }
    }

    @Override
    public List<String> getRacMembership() {
        return this.racMembership;
    }

    @Override
    public List<String> getCrossAccountRacMembership() {
        return null;
    }

    @Override
    public int getRacMembershipSize() {
        if (this.racMembership == null) {
            return 0;
        }
        return this.racMembership.size();
    }

    @Override
    public int getRacCount() {
        return this.racCount;
    }

    @Override
    public void addACL(Collection<String> listIPs, int from, int to) {
    }

    @Override
    public void removeACL(Collection<String> listIPs, int from, int to) {
    }

    @Override
    public List<String> listACL(int from, int to) {
        return null;
    }

    @Override
    public void expandRacMembership(int count) {
    }
}

