/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.xerial.snappy.SnappyOutputStream;

public class ChunkedStream
implements Iterator<byte[]> {
    private boolean hasnext = true;
    private ByteArrayOutputStream bos;
    private SnappyOutputStream compress;
    private InputStream origin;
    private long chunkSize;
    private static int BYTES_TO_READ = 2048;

    public ChunkedStream(InputStream is, long chunkSize) throws IOException {
        this.origin = is;
        this.bos = new ByteArrayOutputStream();
        this.compress = new SnappyOutputStream((OutputStream)this.bos);
        this.chunkSize = chunkSize;
    }

    @Override
    public boolean hasNext() {
        return this.hasnext;
    }

    @Override
    public byte[] next() {
        try {
            int count;
            byte[] data = new byte[BYTES_TO_READ];
            while ((count = this.origin.read(data, 0, data.length)) != -1) {
                this.compress.write(data, 0, count);
                if ((long)this.bos.size() < this.chunkSize) continue;
                return this.returnSafe();
            }
            return this.done();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] done() throws IOException {
        this.compress.flush();
        byte[] return_ = this.bos.toByteArray();
        this.hasnext = false;
        IOUtils.closeQuietly((OutputStream)this.compress);
        IOUtils.closeQuietly((OutputStream)this.bos);
        IOUtils.closeQuietly((InputStream)this.origin);
        return return_;
    }

    private byte[] returnSafe() throws IOException {
        byte[] return_ = this.bos.toByteArray();
        this.bos.reset();
        return return_;
    }

    @Override
    public void remove() {
    }
}

