/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.defaultimpl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.merics.CassMonitorMetrics;
import com.netflix.priam.utils.JMXNodeTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraProcessManager
implements ICassandraProcess {
    private static final Logger logger = LoggerFactory.getLogger(CassandraProcessManager.class);
    private static final String SUDO_STRING = "/usr/bin/sudo";
    private static final int SCRIPT_EXECUTE_WAIT_TIME_MS = 5000;
    protected final IConfiguration config;
    private InstanceState instanceState;
    private CassMonitorMetrics cassMonitorMetrics;

    @Inject
    public CassandraProcessManager(IConfiguration config, InstanceState instanceState, CassMonitorMetrics cassMonitorMetrics) {
        this.config = config;
        this.instanceState = instanceState;
        this.cassMonitorMetrics = cassMonitorMetrics;
    }

    protected void setEnv(Map<String, String> env) {
        env.put("DATA_DIR", this.config.getDataFileLocation());
        env.put("COMMIT_LOG_DIR", this.config.getCommitLogLocation());
        env.put("LOCAL_BACKUP_DIR", this.config.getBackupLocation());
        env.put("CACHE_DIR", this.config.getCacheLocation());
        env.put("JMX_PORT", "" + this.config.getJmxPort());
        env.put("LOCAL_JMX", this.config.enableRemoteJMX() ? "no" : "yes");
        env.put("MAX_DIRECT_MEMORY", this.config.getMaxDirectMemory());
        env.put("CASS_LOGS_DIR", this.config.getLogDirLocation());
        env.put("CASSANDRA_HOME", this.config.getCassHome());
    }

    @Override
    public void start(boolean join_ring) throws IOException {
        logger.info("Starting cassandra server ....Join ring={}", (Object)join_ring);
        this.instanceState.markLastAttemptedStartTime();
        this.instanceState.setShouldCassandraBeAlive(true);
        ArrayList command = Lists.newArrayList();
        if (this.config.useSudo()) {
            logger.info("Configured to use sudo to start C*");
            if (!"root".equals(System.getProperty("user.name"))) {
                command.add(SUDO_STRING);
                command.add("-n");
                command.add("-E");
            }
        }
        command.addAll(this.getStartCommand());
        ProcessBuilder startCass = new ProcessBuilder(command);
        Map<String, String> env = startCass.environment();
        this.setEnv(env);
        env.put("cassandra.join_ring", join_ring ? "true" : "false");
        startCass.directory(new File("/"));
        startCass.redirectErrorStream(true);
        logger.info("Start cmd: {}", startCass.command());
        logger.info("Start env: {}", startCass.environment());
        Process starter = startCass.start();
        logger.info("Starting cassandra server ....");
        try {
            int code = starter.waitFor();
            if (code == 0) {
                logger.info("Cassandra server has been started");
                this.instanceState.setCassandraProcessAlive(true);
                this.cassMonitorMetrics.incCassStart();
            } else {
                logger.error("Unable to start cassandra server. Error code: {}", (Object)code);
            }
            this.logProcessOutput(starter);
        }
        catch (Exception e) {
            logger.warn("Starting Cassandra has an error", (Throwable)e);
        }
    }

    protected List<String> getStartCommand() {
        LinkedList<String> startCmd = new LinkedList<String>();
        for (String param : this.config.getCassStartupScript().split(" ")) {
            if (!StringUtils.isNotBlank((CharSequence)param)) continue;
            startCmd.add(param);
        }
        return startCmd;
    }

    void logProcessOutput(Process p) {
        try {
            String stdOut = this.readProcessStream(p.getInputStream());
            String stdErr = this.readProcessStream(p.getErrorStream());
            logger.info("std_out: {}", (Object)stdOut);
            logger.info("std_err: {}", (Object)stdErr);
        }
        catch (IOException ioe) {
            logger.warn("Failed to read the std out/err streams", (Throwable)ioe);
        }
    }

    String readProcessStream(InputStream inputStream) throws IOException {
        int cnt;
        byte[] buffer = new byte[512];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
        while ((cnt = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, cnt);
        }
        return baos.toString();
    }

    @Override
    public void stop(boolean force) throws IOException {
        logger.info("Stopping cassandra server ....");
        ArrayList command = Lists.newArrayList();
        if (this.config.useSudo()) {
            logger.info("Configured to use sudo to stop C*");
            if (!"root".equals(System.getProperty("user.name"))) {
                command.add(SUDO_STRING);
                command.add("-n");
                command.add("-E");
            }
        }
        for (String param : this.config.getCassStopScript().split(" ")) {
            if (!StringUtils.isNotBlank((CharSequence)param)) continue;
            command.add(param);
        }
        ProcessBuilder stopCass = new ProcessBuilder(command);
        stopCass.directory(new File("/"));
        stopCass.redirectErrorStream(true);
        this.instanceState.setShouldCassandraBeAlive(false);
        if (!force && this.config.getGracefulDrainHealthWaitSeconds() >= 0) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<?> drainFuture = executor.submit(() -> {
                try {
                    Thread.sleep(this.config.getGracefulDrainHealthWaitSeconds() * 1000);
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    JMXNodeTool nodetool = JMXNodeTool.instance(this.config);
                    nodetool.drain();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    logger.error("Exception draining Cassandra, could not drain. Proceeding with shutdown.", (Throwable)e);
                }
            });
            try {
                drainFuture.get(this.config.getGracefulDrainHealthWaitSeconds() + 30, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error("Waited 30s for drain but it did not complete, continuing to shutdown", (Throwable)e);
            }
        }
        Process stopper = stopCass.start();
        try {
            int code = stopper.waitFor();
            if (code == 0) {
                logger.info("Cassandra server has been stopped");
                this.cassMonitorMetrics.incCassStop();
                this.instanceState.setCassandraProcessAlive(false);
            } else {
                logger.error("Unable to stop cassandra server. Error code: {}", (Object)code);
                this.logProcessOutput(stopper);
            }
        }
        catch (Exception e) {
            logger.warn("couldn't shut down cassandra correctly", (Throwable)e);
        }
    }
}

