/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.google;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.netflix.priam.aws.S3BackupPath;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupRestoreException;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredentialGeneric;
import com.netflix.priam.google.GoogleEncryptedFileSystemMBean;
import com.netflix.priam.google.GoogleFileIterator;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleEncryptedFileSystem
implements IBackupFileSystem,
GoogleEncryptedFileSystemMBean {
    private static final Logger logger = LoggerFactory.getLogger(GoogleEncryptedFileSystem.class);
    private static final String APPLICATION_NAME = "gdl";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private HttpTransport httpTransport;
    private Credential credential;
    private Storage gcsStorageHandle;
    private Storage.Objects objectsResoruceHandle = null;
    private Provider<AbstractBackupPath> pathProvider;
    private String srcBucketName;
    private IConfiguration config;
    private AtomicInteger downloadCount = new AtomicInteger();
    protected AtomicLong bytesDownloaded = new AtomicLong();
    private ICredentialGeneric gcsCredential;

    @Inject
    public GoogleEncryptedFileSystem(Provider<AbstractBackupPath> pathProvider, IConfiguration config, @Named(value="gcscredential") ICredentialGeneric credential) {
        this.pathProvider = pathProvider;
        this.config = config;
        this.gcsCredential = credential;
        try {
            this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create a handle to the Google Http tranport", e);
        }
        this.srcBucketName = this.getSourcebucket(this.getPathPrefix());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String mbeanName = "com.priam.google.GoogleEncryptedFileSystemMBean:name=GoogleEncryptedFileSystemMBean";
        try {
            mbs.registerMBean(this, new ObjectName(mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to regiser JMX bean: " + mbeanName + " to JMX server.  Msg: " + e.getLocalizedMessage(), e);
        }
    }

    private String getSourcebucket(String pathPrefix) {
        String[] paths = pathPrefix.split(String.valueOf(S3BackupPath.PATH_SEP));
        return paths[0];
    }

    private Storage.Objects constructObjectResourceHandle() {
        if (this.objectsResoruceHandle != null) {
            return this.objectsResoruceHandle;
        }
        this.constructGcsStorageHandle();
        this.objectsResoruceHandle = this.gcsStorageHandle.objects();
        return this.objectsResoruceHandle;
    }

    private Storage constructGcsStorageHandle() {
        if (this.gcsStorageHandle != null) {
            return this.gcsStorageHandle;
        }
        try {
            this.constructGcsCredential();
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception during GCS authorization", e);
        }
        this.gcsStorageHandle = new Storage.Builder(this.httpTransport, JSON_FACTORY, (HttpRequestInitializer)this.credential).setApplicationName(APPLICATION_NAME).build();
        return this.gcsStorageHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Credential constructGcsCredential() throws Exception {
        if (this.credential != null) {
            return this.credential;
        }
        GoogleEncryptedFileSystem googleEncryptedFileSystem = this;
        synchronized (googleEncryptedFileSystem) {
            if (this.credential == null) {
                String service_acct_email = new String(this.gcsCredential.getValue(ICredentialGeneric.KEY.GCS_SERVICE_ID));
                if (this.config.getGcsServiceAccountPrivateKeyLoc() == null || this.config.getGcsServiceAccountPrivateKeyLoc().isEmpty()) {
                    throw new NullPointerException("Fast property for the the GCS private key file is null/empty.");
                }
                File gcsPrivateKeyHandle = new File(this.config.getGcsServiceAccountPrivateKeyLoc() + ".output");
                FileOutputStream os = new FileOutputStream(gcsPrivateKeyHandle);
                BufferedOutputStream bos = new BufferedOutputStream(os);
                ByteArrayOutputStream byteos = new ByteArrayOutputStream();
                byte[] gcsPrivateKeyPlainText = this.gcsCredential.getValue(ICredentialGeneric.KEY.GCS_PRIVATE_KEY_LOC);
                try {
                    byteos.write(gcsPrivateKeyPlainText);
                    byteos.writeTo(bos);
                }
                catch (IOException e) {
                    throw new IOException("Exception when writing decrypted gcs private key value to disk.", e);
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        throw new IOException("Exception when closing decrypted gcs private key value to disk.", e);
                    }
                }
                ArrayList<String> scopes = new ArrayList<String>(1);
                scopes.add("https://www.googleapis.com/auth/devstorage.read_only");
                this.credential = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(JSON_FACTORY).setServiceAccountId(service_acct_email).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(gcsPrivateKeyHandle).build();
            }
        }
        return this.credential;
    }

    @Override
    public void download(AbstractBackupPath path, OutputStream os) throws BackupRestoreException {
        logger.info("Downloading {} from GCS bucket {}", (Object)path.getRemotePath(), (Object)this.srcBucketName);
        this.downloadCount.incrementAndGet();
        String objectName = GoogleEncryptedFileSystem.parseObjectname(this.getPathPrefix());
        Storage.Objects.Get get = null;
        try {
            get = this.constructObjectResourceHandle().get(this.srcBucketName, path.getRemotePath());
        }
        catch (IOException e) {
            throw new BackupRestoreException("IO error retrieving metadata for: " + objectName + " from bucket: " + this.srcBucketName, e);
        }
        get.getMediaHttpDownloader().setDirectDownloadEnabled(true);
        InputStream is = null;
        try {
            is = get.executeMediaAsInputStream();
            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new BackupRestoreException("IO error during streaming of object: " + objectName + " from bucket: " + this.srcBucketName, e);
        }
        catch (Exception ex) {
            throw new BackupRestoreException("Exception encountered when copying bytes from input to output", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        this.bytesDownloaded.addAndGet(get.getLastResponseHeaders().getContentLength());
    }

    @Override
    public void download(AbstractBackupPath path, OutputStream os, String filePath) throws BackupRestoreException {
        try {
            this.download(path, os);
        }
        catch (Exception e) {
            throw new BackupRestoreException(e.getMessage(), e);
        }
    }

    @Override
    public void upload(AbstractBackupPath path, InputStream in) throws BackupRestoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<AbstractBackupPath> list(String path, Date start, Date till) {
        return new GoogleFileIterator(this.pathProvider, this.constructGcsStorageHandle(), path, start, till);
    }

    @Override
    public Iterator<AbstractBackupPath> listPrefixes(Date date) {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public int getActivecount() {
        return 0;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public int downloadCount() {
        return this.downloadCount.get();
    }

    @Override
    public int uploadCount() {
        return 0;
    }

    @Override
    public long bytesUploaded() {
        return 0L;
    }

    @Override
    public long getBytesUploaded() {
        return 0L;
    }

    @Override
    public long getAWSSlowDownExceptionCounter() {
        return 0L;
    }

    @Override
    public long bytesDownloaded() {
        return this.bytesDownloaded.get();
    }

    public String getPathPrefix() {
        String prefix = StringUtils.isNotBlank((CharSequence)this.config.getRestorePrefix()) ? this.config.getRestorePrefix() : this.config.getBackupPrefix();
        return prefix;
    }

    public static String parseObjectname(String pathPrefix) {
        int offset = pathPrefix.lastIndexOf(47);
        return pathPrefix.substring(offset + 1);
    }
}

