/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.restore;

import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.restore.AwsCrossAccountCryptographyRestoreStrategy;
import com.netflix.priam.restore.EncryptedRestoreStrategy;
import com.netflix.priam.restore.GoogleCryptographyRestoreStrategy;
import com.netflix.priam.restore.Restore;
import com.netflix.priam.scheduler.PriamScheduler;
import com.netflix.priam.scheduler.UnsupportedTypeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreContext {
    private final PriamScheduler scheduler;
    private final IConfiguration config;
    private static final Logger logger = LoggerFactory.getLogger(RestoreContext.class);

    @Inject
    public RestoreContext(IConfiguration config, PriamScheduler scheduler) {
        this.config = config;
        this.scheduler = scheduler;
    }

    public boolean isRestoreEnabled() {
        return !StringUtils.isEmpty((CharSequence)this.config.getRestoreSnapshot());
    }

    public void restore() throws Exception {
        if (!this.isRestoreEnabled()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.config.getRestoreSourceType()) && !this.config.isRestoreEncrypted()) {
            this.scheduler.addTask("AUTO_RESTORE_JOB", Restore.class, Restore.getTimer());
            logger.info("Scheduled task AUTO_RESTORE_JOB");
        } else if (this.config.isRestoreEncrypted()) {
            SourceType sourceType = SourceType.lookup(this.config.getRestoreSourceType(), true, false);
            if (sourceType == null) {
                this.scheduler.addTask("CRYPTOGRAPHY_RESTORE_JOB", EncryptedRestoreStrategy.class, EncryptedRestoreStrategy.getTimer());
                logger.info("Scheduled task AUTO_RESTORE_JOB");
                return;
            }
            switch (sourceType) {
                case AWSCROSSACCT: {
                    this.scheduler.addTask("AWS_CROSS_ACCT_CRYPTOGRAPHY_RESTORE_JOB", AwsCrossAccountCryptographyRestoreStrategy.class, AwsCrossAccountCryptographyRestoreStrategy.getTimer());
                    logger.info("Scheduled task AWS_CROSS_ACCT_CRYPTOGRAPHY_RESTORE_JOB");
                    break;
                }
                case GOOGLE: {
                    this.scheduler.addTask("GOOGLECLOUDSTORAGE_RESTORE_JOB", GoogleCryptographyRestoreStrategy.class, GoogleCryptographyRestoreStrategy.getTimer());
                    logger.info("Scheduled task GOOGLECLOUDSTORAGE_RESTORE_JOB");
                }
            }
        }
    }

    static enum SourceType {
        AWSCROSSACCT("AWSCROSSACCT"),
        GOOGLE("GOOGLE");

        private static final Logger logger;
        private final String sourceType;

        private SourceType(String sourceType) {
            this.sourceType = sourceType.toUpperCase();
        }

        public static SourceType lookup(String sourceType, boolean acceptNullOrEmpty, boolean acceptIllegalValue) throws UnsupportedTypeException {
            if (StringUtils.isEmpty((CharSequence)sourceType)) {
                if (acceptNullOrEmpty) {
                    return null;
                }
                String message = String.format("%s is not a supported SourceType. Supported values are %s", sourceType, SourceType.getSupportedValues());
                logger.error(message);
                throw new UnsupportedTypeException(message);
            }
            try {
                return SourceType.valueOf(sourceType.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                String message = String.format("%s is not a supported SourceType. Supported values are %s", sourceType, SourceType.getSupportedValues());
                if (acceptIllegalValue) {
                    message = message + ". Since acceptIllegalValue is set to True, returning NULL instead.";
                    logger.error(message);
                    return null;
                }
                logger.error(message);
                throw new UnsupportedTypeException(message, ex);
            }
        }

        private static String getSupportedValues() {
            StringBuffer supportedValues = new StringBuffer();
            boolean first = true;
            for (SourceType type : SourceType.values()) {
                if (!first) {
                    supportedValues.append(",");
                }
                supportedValues.append((Object)type);
                first = false;
            }
            return supportedValues.toString();
        }

        public static SourceType lookup(String sourceType) throws UnsupportedTypeException {
            return SourceType.lookup(sourceType, false, false);
        }

        public String getSourceType() {
            return this.sourceType;
        }

        static {
            logger = LoggerFactory.getLogger(SourceType.class);
        }
    }
}

