/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.restore;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.utils.ITokenManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class RestoreTokenSelector {
    private final ITokenManager tokenManager;
    private final IBackupFileSystem fs;

    @Inject
    public RestoreTokenSelector(ITokenManager tokenManager, @Named(value="backup") IBackupFileSystem fs) {
        this.tokenManager = tokenManager;
        this.fs = fs;
    }

    public BigInteger getClosestToken(BigInteger tokenToSearch, Date startDate) {
        ArrayList<BigInteger> tokenList = new ArrayList<BigInteger>();
        Iterator<AbstractBackupPath> iter = this.fs.listPrefixes(startDate);
        while (iter.hasNext()) {
            tokenList.add(new BigInteger(iter.next().getToken()));
        }
        return this.tokenManager.findClosestToken(tokenToSearch, tokenList);
    }
}

