/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NamedThreadPoolExecutor
extends ThreadPoolExecutor {
    public NamedThreadPoolExecutor(int poolSize, String poolName) {
        this(poolSize, poolName, new LinkedBlockingQueue<Runnable>());
    }

    public NamedThreadPoolExecutor(int poolSize, String poolName, BlockingQueue<Runnable> queue) {
        super(poolSize, poolSize, 1000L, TimeUnit.MILLISECONDS, queue, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(poolName + "-%d").build(), new LocalRejectedExecutionHandler(queue));
    }

    private static class LocalRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final BlockingQueue<Runnable> queue;

        LocalRejectedExecutionHandler(BlockingQueue<Runnable> queue) {
            this.queue = queue;
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            while (true) {
                if (executor.isShutdown()) {
                    throw new RejectedExecutionException("ThreadPoolExecutor has shut down");
                }
                try {
                    if (!this.queue.offer(task, 1000L, TimeUnit.MILLISECONDS)) continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

