/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.services;

import com.google.inject.Provider;
import com.netflix.priam.backup.AbstractBackup;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupRestoreUtil;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backupv2.ColumnfamilyResult;
import com.netflix.priam.backupv2.FileUploadResult;
import com.netflix.priam.backupv2.MetaFileManager;
import com.netflix.priam.backupv2.MetaFileWriterBuilder;
import com.netflix.priam.backupv2.PrefixGenerator;
import com.netflix.priam.config.IBackupRestoreConfig;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.CassandraOperations;
import com.netflix.priam.scheduler.CronTimer;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.utils.CassandraMonitor;
import com.netflix.priam.utils.DateUtil;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SnapshotMetaService
extends AbstractBackup {
    public static final String JOBNAME = "SnapshotMetaService";
    private static final Logger logger = LoggerFactory.getLogger(SnapshotMetaService.class);
    private static final String SNAPSHOT_PREFIX = "snap_v2_";
    private static final String CASSANDRA_MANIFEST_FILE = "manifest.json";
    private BackupRestoreUtil backupRestoreUtil;
    private MetaFileWriterBuilder metaFileWriter;
    private MetaFileWriterBuilder.DataStep dataStep;
    private MetaFileManager metaFileManager;
    private CassandraOperations cassandraOperations;
    private String snapshotName = null;

    @Inject
    SnapshotMetaService(IConfiguration config, IFileSystemContext backupFileSystemCtx, Provider<AbstractBackupPath> pathFactory, MetaFileWriterBuilder metaFileWriter, MetaFileManager metaFileManager, CassandraOperations cassandraOperations) {
        super(config, backupFileSystemCtx, pathFactory);
        this.cassandraOperations = cassandraOperations;
        this.backupRestoreUtil = new BackupRestoreUtil(config.getSnapshotKeyspaceFilters(), config.getSnapshotCFFilter());
        this.metaFileWriter = metaFileWriter;
        this.metaFileManager = metaFileManager;
    }

    public static TaskTimer getTimer(IBackupRestoreConfig backupRestoreConfig) throws Exception {
        CronTimer cronTimer = null;
        String cronExpression = backupRestoreConfig.getSnapshotMetaServiceCronExpression();
        if (!StringUtils.isEmpty((CharSequence)cronExpression) && cronExpression.equalsIgnoreCase("-1")) {
            logger.info("Skipping SnapshotMetaService as SnapshotMetaService cron is disabled via -1.");
        } else {
            if (StringUtils.isEmpty((CharSequence)cronExpression) || !CronExpression.isValidExpression((String)cronExpression)) {
                throw new Exception("Invalid CRON expression: " + cronExpression + ". Please use -1, if you wish to disable SnapshotMetaService else fix the CRON expression and try again!");
            }
            cronTimer = new CronTimer(JOBNAME, cronExpression);
            logger.info("Starting SnapshotMetaService with CRON expression {}", (Object)cronTimer.getCronExpression());
        }
        return cronTimer;
    }

    String generateSnapshotName(Instant snapshotInstant) {
        return SNAPSHOT_PREFIX + DateUtil.formatInstant("yyyyMMddHHmm", snapshotInstant);
    }

    @Override
    public void execute() throws Exception {
        if (!CassandraMonitor.hasCassadraStarted().booleanValue()) {
            logger.debug("Cassandra has not started, hence SnapshotMetaService will not run");
            return;
        }
        try {
            Instant snapshotInstant = DateUtil.getInstant();
            this.snapshotName = this.generateSnapshotName(snapshotInstant);
            logger.info("Initializing SnapshotMetaService for taking a snapshot {}", (Object)this.snapshotName);
            this.metaFileManager.cleanupOldMetaFiles();
            this.cassandraOperations.takeSnapshot(this.snapshotName);
            this.processSnapshot(snapshotInstant).uploadMetaFile(true);
            logger.info("Finished processing snapshot meta service");
        }
        catch (Exception e) {
            logger.error("Error while executing SnapshotMetaService", (Throwable)e);
        }
    }

    MetaFileWriterBuilder.UploadStep processSnapshot(Instant snapshotInstant) throws Exception {
        this.dataStep = this.metaFileWriter.newBuilder().startMetaFileGeneration(snapshotInstant);
        this.initiateBackup("snapshots", this.backupRestoreUtil);
        return this.dataStep.endMetaFileGeneration();
    }

    private File getValidSnapshot(File snapshotDir, String snapshotName) {
        for (File fileName : snapshotDir.listFiles()) {
            if (!fileName.exists() || !fileName.isDirectory() || !fileName.getName().matches(snapshotName)) continue;
            return fileName;
        }
        return null;
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    private ColumnfamilyResult convertToColumnFamilyResult(String keyspace, String columnFamilyName, Map<String, List<FileUploadResult>> filePrefixToFileMap) {
        ColumnfamilyResult columnfamilyResult = new ColumnfamilyResult(keyspace, columnFamilyName);
        filePrefixToFileMap.entrySet().forEach(sstableEntry -> {
            ColumnfamilyResult.SSTableResult ssTableResult = new ColumnfamilyResult.SSTableResult();
            ssTableResult.setPrefix((String)sstableEntry.getKey());
            ssTableResult.setSstableComponents((List)sstableEntry.getValue());
            columnfamilyResult.addSstable(ssTableResult);
        });
        return columnfamilyResult;
    }

    @Override
    protected void processColumnFamily(String keyspace, String columnFamily, File backupDir) throws Exception {
        File snapshotDir = this.getValidSnapshot(backupDir, this.snapshotName);
        if (snapshotDir == null) {
            logger.warn("{} folder does not contain {} snapshots", (Object)backupDir, (Object)this.snapshotName);
            return;
        }
        logger.debug("Scanning for all SSTables in: {}", (Object)snapshotDir.getAbsolutePath());
        HashMap<String, List<FileUploadResult>> filePrefixToFileMap = new HashMap<String, List<FileUploadResult>>();
        Collection files = FileUtils.listFiles((File)snapshotDir, (IOFileFilter)FileFilterUtils.fileFileFilter(), null);
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                String prefix = PrefixGenerator.getSSTFileBase(file.getName());
                if (prefix == null && file.getName().equalsIgnoreCase(CASSANDRA_MANIFEST_FILE)) {
                    prefix = "manifest";
                }
                if (prefix == null) {
                    logger.error("Unknown file type with no SSTFileBase found: ", (Object)file.getAbsolutePath());
                    return;
                }
                FileUploadResult fileUploadResult = FileUploadResult.getFileUploadResult(keyspace, columnFamily, file);
                filePrefixToFileMap.putIfAbsent(prefix, new ArrayList());
                ((List)filePrefixToFileMap.get(prefix)).add(fileUploadResult);
            }
            catch (Exception e) {
                logger.error("Internal error while trying to generate FileUploadResult and/or reading FileAttributes for file: " + file.getAbsolutePath(), (Throwable)e);
                throw e;
            }
        }
        ColumnfamilyResult columnfamilyResult = this.convertToColumnFamilyResult(keyspace, columnFamily, filePrefixToFileMap);
        filePrefixToFileMap.clear();
        logger.debug("Starting the processing of KS: {}, CF: {}, No.of SSTables: {}", new Object[]{columnfamilyResult.getKeyspaceName(), columnfamilyResult.getColumnfamilyName(), columnfamilyResult.getSstables().size()});
        FileUtils.cleanDirectory((File)snapshotDir);
        FileUtils.deleteDirectory((File)snapshotDir);
        this.dataStep.addColumnfamilyResult(columnfamilyResult);
        logger.debug("Finished processing KS: {}, CF: {}", (Object)columnfamilyResult.getKeyspaceName(), (Object)columnfamilyResult.getColumnfamilyName());
    }

    @Override
    protected void addToRemotePath(String remotePath) {
    }

    void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }
}

