/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner;

import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.tuner.GCTuner;
import com.netflix.priam.tuner.GCType;
import com.netflix.priam.tuner.JVMOption;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMOptionsTuner {
    private static final Logger logger = LoggerFactory.getLogger(JVMOptionsTuner.class);
    protected final IConfiguration config;

    @Inject
    public JVMOptionsTuner(IConfiguration config) {
        this.config = config;
    }

    public void updateAndSaveJVMOptions(String outputFile) throws Exception {
        File file;
        List<String> configuredJVMOptions = this.updateJVMOptions();
        if (logger.isInfoEnabled()) {
            StringBuffer buffer = new StringBuffer("\n");
            configuredJVMOptions.stream().forEach(line -> buffer.append((String)line).append("\n"));
            logger.info("Updating jvm.options with following values: " + buffer.toString());
        }
        if ((file = new File(outputFile)).exists() && !file.canWrite()) {
            throw new Exception("Not enough permissions to write to file: " + outputFile);
        }
        Files.write(new File(outputFile).toPath(), configuredJVMOptions, new OpenOption[0]);
    }

    protected List<String> updateJVMOptions() throws Exception {
        File jvmOptionsFile = new File(this.config.getJVMOptionsFileLocation());
        this.validate(jvmOptionsFile);
        GCType configuredGC = this.config.getGCType();
        Map<String, JVMOption> excludeSet = this.config.getJVMExcludeSet();
        Map<String, JVMOption> upsertSet = this.config.getJVMUpsertSet();
        List optionsFromFile = Files.lines(jvmOptionsFile.toPath()).collect(Collectors.toList());
        LinkedList<String> configuredOptions = new LinkedList<String>();
        for (String line : optionsFromFile) {
            configuredOptions.add(this.updateConfigurationValue(line, configuredGC, upsertSet, excludeSet));
        }
        if (upsertSet != null && !upsertSet.isEmpty()) {
            configuredOptions.add("#################");
            configuredOptions.add("# USER PROVIDED CUSTOM JVM CONFIGURATIONS #");
            configuredOptions.add("#################");
            configuredOptions.addAll(upsertSet.values().stream().map(jvmOption -> jvmOption.toJVMOptionString()).collect(Collectors.toList()));
        }
        return configuredOptions;
    }

    private void setHeapSetting(String configuredValue, JVMOption option) {
        if (!StringUtils.isEmpty((CharSequence)configuredValue)) {
            option.setCommented(false).setValue(configuredValue);
        }
    }

    private String updateConfigurationValue(String line, GCType configuredGC, Map<String, JVMOption> upsertSet, Map<String, JVMOption> excludeSet) {
        GCType gcType;
        JVMOption option = JVMOption.parse(line);
        if (option == null) {
            return line;
        }
        if (option.isHeapJVMOption()) {
            String configuredValue = null;
            switch (option.getJvmOption()) {
                case "-Xmn": {
                    configuredValue = this.config.getHeapNewSize();
                    break;
                }
                default: {
                    configuredValue = this.config.getHeapSize();
                }
            }
            this.setHeapSetting(configuredValue, option);
        }
        if (option.getJvmOption().equals("-Xmn") && configuredGC == GCType.G1GC) {
            option.setCommented(true);
        }
        if ((gcType = GCTuner.getGCType(option)) != null) {
            option.setCommented(gcType != configuredGC);
        }
        if (upsertSet != null && upsertSet.containsKey(option.getJvmOption())) {
            JVMOption configuration = upsertSet.get(option.getJvmOption());
            option.setCommented(false);
            option.setValue(configuration.getValue());
            upsertSet.remove(option.getJvmOption());
        }
        if (excludeSet != null && excludeSet.containsKey(option.getJvmOption())) {
            option.setCommented(true);
        }
        return option.toJVMOptionString();
    }

    private void validate(File jvmOptionsFile) throws Exception {
        if (!jvmOptionsFile.exists()) {
            throw new Exception("JVM Option File does not exist: " + jvmOptionsFile.getAbsolutePath());
        }
        if (jvmOptionsFile.isDirectory()) {
            throw new Exception("JVM Option File is a directory: " + jvmOptionsFile.getAbsolutePath());
        }
        if (!jvmOptionsFile.canRead() || !jvmOptionsFile.canWrite()) {
            throw new Exception("JVM Option File does not have right permission: " + jvmOptionsFile.getAbsolutePath());
        }
    }

    public static final Map<String, JVMOption> parseJVMOptions(String property) {
        if (StringUtils.isEmpty((CharSequence)property)) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(property.split(","))).stream().map(line -> JVMOption.parse(line)).filter(jvmOption -> jvmOption != null).collect(Collectors.toMap(jvmOption -> jvmOption.getJvmOption(), jvmOption -> jvmOption));
    }
}

