/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner.dse;

import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.tuner.StandardTuner;
import com.netflix.priam.tuner.dse.IAuditLogTuner;
import com.netflix.priam.tuner.dse.IDseConfiguration;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DseTuner
extends StandardTuner {
    private static final Logger logger = LoggerFactory.getLogger(DseTuner.class);
    private final IDseConfiguration dseConfig;
    private final IAuditLogTuner auditLogTuner;

    @Inject
    public DseTuner(IConfiguration config, IDseConfiguration dseConfig, IAuditLogTuner auditLogTuner) {
        super(config);
        this.dseConfig = dseConfig;
        this.auditLogTuner = auditLogTuner;
    }

    @Override
    public void writeAllProperties(String yamlLocation, String hostname, String seedProvider) throws Exception {
        super.writeAllProperties(yamlLocation, hostname, seedProvider);
        this.writeCassandraSnitchProperties();
        this.auditLogTuner.tuneAuditLog();
    }

    private void writeCassandraSnitchProperties() {
        IDseConfiguration.NodeType nodeType = this.dseConfig.getNodeType();
        if (nodeType == IDseConfiguration.NodeType.REAL_TIME_QUERY) {
            return;
        }
        FileReader reader = null;
        try {
            String filePath = this.config.getCassHome() + "/conf/" + "cassandra-rackdc.properties";
            reader = new FileReader(filePath);
            Properties properties = new Properties();
            properties.load(reader);
            String suffix = "";
            if (nodeType == IDseConfiguration.NodeType.SEARCH) {
                suffix = "_solr";
            }
            if (nodeType == IDseConfiguration.NodeType.ANALYTIC_HADOOP) {
                suffix = "_hadoop";
            }
            if (nodeType == IDseConfiguration.NodeType.ANALYTIC_HADOOP_SPARK) {
                suffix = "_hadoop_spark";
            }
            if (nodeType == IDseConfiguration.NodeType.ANALYTIC_SPARK) {
                suffix = "_spark";
            }
            properties.put("dc_suffix", suffix);
            properties.store(new FileWriter(filePath), "");
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to read cassandra-rackdc.properties", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        FileUtils.closeQuietly((Closeable)reader);
    }

    @Override
    protected String getSnitch() {
        return this.dseConfig.getDseDelegatingSnitch();
    }
}

