/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.merics.CassMonitorMetrics;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.Task;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.utils.JMXNodeTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CassandraMonitor
extends Task {
    public static final String JOBNAME = "CASS_MONITOR_THREAD";
    private static final Logger logger = LoggerFactory.getLogger(CassandraMonitor.class);
    private static final AtomicBoolean isCassandraStarted = new AtomicBoolean(false);
    private InstanceState instanceState;
    private ICassandraProcess cassProcess;
    private CassMonitorMetrics cassMonitorMetrics;

    @Inject
    protected CassandraMonitor(IConfiguration config, InstanceState instanceState, ICassandraProcess cassProcess, CassMonitorMetrics cassMonitorMetrics) {
        super(config);
        this.instanceState = instanceState;
        this.cassProcess = cassProcess;
        this.cassMonitorMetrics = cassMonitorMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        block17: {
            BufferedReader input;
            block16: {
                try {
                    this.checkRequiredDirectories();
                    this.instanceState.setIsRequiredDirectoriesExist(true);
                }
                catch (IllegalStateException e) {
                    this.instanceState.setIsRequiredDirectoriesExist(false);
                }
                Process process = null;
                input = null;
                try {
                    String[] cmd = new String[]{"/bin/sh", "-c", "ps -ef |grep -v -P \"\\sgrep\\s\" | grep " + this.config.getCassProcessName()};
                    process = Runtime.getRuntime().exec(cmd);
                    input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = input.readLine();
                    if (line != null) {
                        this.instanceState.setCassandraProcessAlive(true);
                        isCassandraStarted.set(true);
                        JMXNodeTool bean = JMXNodeTool.instance(this.config);
                        this.instanceState.setIsGossipActive(bean.isGossipRunning());
                        this.instanceState.setIsNativeTransportActive(bean.isNativeTransportRunning());
                    } else {
                        this.instanceState.setCassandraProcessAlive(false);
                        isCassandraStarted.set(false);
                    }
                    if (process == null) break block16;
                }
                catch (Exception e) {
                    logger.warn("Exception thrown while checking if Cassandra is running or not ", (Throwable)e);
                    this.instanceState.setCassandraProcessAlive(false);
                    isCassandraStarted.set(false);
                    break block17;
                }
                finally {
                    if (process != null) {
                        IOUtils.closeQuietly((InputStream)process.getInputStream());
                        IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                        IOUtils.closeQuietly((InputStream)process.getErrorStream());
                    }
                    if (input != null) {
                        IOUtils.closeQuietly(input);
                    }
                }
                IOUtils.closeQuietly((InputStream)process.getInputStream());
                IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                IOUtils.closeQuietly((InputStream)process.getErrorStream());
            }
            if (input != null) {
                IOUtils.closeQuietly((Reader)input);
            }
        }
        try {
            int rate = this.config.getRemediateDeadCassandraRate();
            if (rate >= 0 && !this.config.doesCassandraStartManually() && this.instanceState.shouldCassandraBeAlive() && !this.instanceState.isCassandraProcessAlive()) {
                long msNow = System.currentTimeMillis();
                if (rate == 0 || this.instanceState.getLastAttemptedStartTime() + (long)(rate * 1000) < msNow) {
                    this.cassMonitorMetrics.incCassAutoStart();
                    this.cassProcess.start(true);
                    this.instanceState.markLastAttemptedStartTime();
                }
            }
        }
        catch (IOException e) {
            logger.warn("Failed to remediate dead Cassandra", (Throwable)e);
        }
    }

    private void checkRequiredDirectories() {
        this.checkDirectory(this.config.getDataFileLocation());
        this.checkDirectory(this.config.getBackupCommitLogLocation());
        this.checkDirectory(this.config.getCommitLogLocation());
        this.checkDirectory(this.config.getCacheLocation());
        this.checkDirectory(this.config.getHintsLocation());
        this.checkDirectory(this.config.getLogDirLocation());
    }

    private void checkDirectory(String directory) {
        this.checkDirectory(new File(directory));
    }

    private void checkDirectory(File directory) {
        if (!directory.exists()) {
            throw new IllegalStateException(String.format("Directory: {} does not exist", directory));
        }
        if (!directory.canRead() || !directory.canWrite()) {
            throw new IllegalStateException(String.format("Directory: {} does not have read/write permissions.", new Object[0]));
        }
    }

    public static TaskTimer getTimer() {
        return new SimpleTimer(JOBNAME, 10000L);
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    public static Boolean hasCassadraStarted() {
        return isCassandraStarted.get();
    }

    public static void setIsCassadraStarted() {
        isCassandraStarted.set(true);
    }
}

