/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.netflix.priam.utils.SystemUtils;

public class DataPart {
    private final String bucketName;
    private final String uploadID;
    private final String s3key;
    private int partNo;
    private byte[] partData;
    private byte[] md5;

    public DataPart(String bucket, String s3key, String mUploadId) {
        this.bucketName = bucket;
        this.uploadID = mUploadId;
        this.s3key = s3key;
    }

    public DataPart(int partNumber, byte[] data, String bucket, String s3key, String mUploadId) {
        this(bucket, s3key, mUploadId);
        this.partNo = partNumber;
        this.partData = data;
        this.md5 = SystemUtils.md5(data);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getUploadID() {
        return this.uploadID;
    }

    public String getS3key() {
        return this.s3key;
    }

    public int getPartNo() {
        return this.partNo;
    }

    public byte[] getPartData() {
        return this.partData;
    }

    public byte[] getMd5() {
        return this.md5;
    }
}

