/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.netflix.priam.aws.S3BackupPath;
import com.netflix.priam.backup.AbstractBackupPath;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileIterator
implements Iterator<AbstractBackupPath> {
    private static final Logger logger = LoggerFactory.getLogger(S3FileIterator.class);
    private final Provider<AbstractBackupPath> pathProvider;
    private final AmazonS3 s3Client;
    private final Date start;
    private final Date till;
    private Iterator<AbstractBackupPath> iterator;
    private ObjectListing objectListing;

    public S3FileIterator(Provider<AbstractBackupPath> pathProvider, AmazonS3 s3Client, String path, Date start, Date till) {
        this.start = start;
        this.till = till;
        this.pathProvider = pathProvider;
        ListObjectsRequest listReq = new ListObjectsRequest();
        String[] paths = path.split(String.valueOf(S3BackupPath.PATH_SEP));
        listReq.setBucketName(paths[0]);
        listReq.setPrefix(((AbstractBackupPath)pathProvider.get()).remotePrefix(start, till, path));
        this.s3Client = s3Client;
        this.objectListing = s3Client.listObjects(listReq);
        this.iterator = this.createIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        while (this.objectListing.isTruncated() && !this.iterator.hasNext()) {
            this.objectListing = this.s3Client.listNextBatchOfObjects(this.objectListing);
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    private Iterator<AbstractBackupPath> createIterator() {
        ArrayList temp = Lists.newArrayList();
        for (S3ObjectSummary summary : this.objectListing.getObjectSummaries()) {
            AbstractBackupPath path = (AbstractBackupPath)this.pathProvider.get();
            path.parseRemote(summary.getKey());
            logger.debug("New key {} path = {} start: {} end: {} my {}", new Object[]{summary.getKey(), path.getRemotePath(), this.start, this.till, path.getTime()});
            if ((!path.getTime().after(this.start) || !path.getTime().before(this.till)) && !path.getTime().equals(this.start)) continue;
            temp.add(path);
            logger.debug("Added key {}", (Object)summary.getKey());
        }
        return temp.iterator();
    }

    @Override
    public AbstractBackupPath next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }
}

