/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.aws.DataPart;
import com.netflix.priam.aws.S3FileSystemBase;
import com.netflix.priam.aws.S3FileSystemMBean;
import com.netflix.priam.aws.S3PartUploader;
import com.netflix.priam.aws.auth.IS3Credential;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupRestoreException;
import com.netflix.priam.backup.RangeReadInputStream;
import com.netflix.priam.compress.ICompression;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.merics.BackupMetrics;
import com.netflix.priam.notification.BackupNotificationMgr;
import com.netflix.priam.utils.BoundedExponentialRetryCallable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class S3FileSystem
extends S3FileSystemBase
implements S3FileSystemMBean {
    private static final Logger logger = LoggerFactory.getLogger(S3FileSystem.class);

    @Inject
    public S3FileSystem(@Named(value="awss3roleassumption") IS3Credential cred, Provider<AbstractBackupPath> pathProvider, ICompression compress, IConfiguration config, BackupMetrics backupMetrics, BackupNotificationMgr backupNotificationMgr) {
        super(pathProvider, compress, config, backupMetrics, backupNotificationMgr);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("com.priam.aws.S3FileSystemMBean:name=S3FileSystemMBean"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(cred.getAwsCredentialProvider())).withRegion(config.getDC())).build();
    }

    @Override
    public void downloadFile(AbstractBackupPath path, OutputStream os) throws BackupRestoreException {
        try {
            RangeReadInputStream rris = new RangeReadInputStream(this.s3Client, this.getPrefix(this.config), path);
            long bufSize = 0x500000L > path.getSize() ? path.getSize() : 0x500000L;
            this.compress.decompressAndClose(new BufferedInputStream(rris, (int)bufSize), os);
        }
        catch (Exception e) {
            throw new BackupRestoreException("Exception encountered downloading " + path.getRemotePath() + " from S3 bucket " + this.getPrefix(this.config) + ", Msg: " + e.getMessage(), e);
        }
    }

    private void uploadMultipart(AbstractBackupPath path, InputStream in, long chunkSize) throws BackupRestoreException {
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.config.getBackupPrefix(), path.getRemotePath());
        InitiateMultipartUploadResult initResponse = this.s3Client.initiateMultipartUpload(initRequest);
        DataPart part = new DataPart(this.config.getBackupPrefix(), path.getRemotePath(), initResponse.getUploadId());
        List<PartETag> partETags = Collections.synchronizedList(new ArrayList());
        try {
            Iterator<byte[]> chunks = this.compress.compress(in, chunkSize);
            int partNum = 0;
            AtomicInteger partsUploaded = new AtomicInteger(0);
            while (chunks.hasNext()) {
                byte[] chunk = chunks.next();
                this.rateLimiter.acquire(chunk.length);
                DataPart dp = new DataPart(++partNum, chunk, this.config.getBackupPrefix(), path.getRemotePath(), initResponse.getUploadId());
                S3PartUploader partUploader = new S3PartUploader(this.s3Client, dp, partETags, partsUploaded);
                this.executor.submit(partUploader);
                this.bytesUploaded.addAndGet(chunk.length);
            }
            this.executor.sleepTillEmpty();
            logger.info("All chunks uploaded for file {}, num of expected parts:{}, num of actual uploaded parts: {}", new Object[]{path.getFileName(), partNum, partsUploaded.get()});
            if (partNum != partETags.size()) {
                throw new BackupRestoreException("Number of parts(" + partNum + ")  does not match the uploaded parts(" + partETags.size() + ")");
            }
            CompleteMultipartUploadResult resultS3MultiPartUploadComplete = new S3PartUploader(this.s3Client, part, partETags).completeUpload();
            this.checkSuccessfulUpload(resultS3MultiPartUploadComplete, path);
            if (logger.isDebugEnabled()) {
                S3ResponseMetadata responseMetadata = this.s3Client.getCachedResponseMetadata((AmazonWebServiceRequest)initRequest);
                String requestId = responseMetadata.getRequestId();
                String hostId = responseMetadata.getHostId();
                logger.debug("S3 AWS x-amz-request-id[" + requestId + "], and x-amz-id-2[" + hostId + "]");
            }
        }
        catch (Exception e) {
            throw this.encounterError(path, new S3PartUploader(this.s3Client, part, partETags), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void uploadFile(AbstractBackupPath path, InputStream in, long chunkSize) throws BackupRestoreException {
        if (path.getSize() < chunkSize) {
            if (logger.isDebugEnabled()) {
                logger.debug("Uploading file using put: {}", (Object)path.getRemotePath());
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                Iterator<byte[]> chunkedStream = this.compress.compress(in, chunkSize);
                while (chunkedStream.hasNext()) {
                    byteArrayOutputStream.write(chunkedStream.next());
                }
                byte[] chunk = byteArrayOutputStream.toByteArray();
                this.rateLimiter.acquire(chunk.length);
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setContentLength((long)chunk.length);
                final PutObjectRequest putObjectRequest = new PutObjectRequest(this.config.getBackupPrefix(), path.getRemotePath(), (InputStream)new ByteArrayInputStream(chunk), objectMetadata);
                PutObjectResult upload = new BoundedExponentialRetryCallable<PutObjectResult>(){

                    @Override
                    public PutObjectResult retriableCall() throws Exception {
                        return S3FileSystem.this.s3Client.putObject(putObjectRequest);
                    }
                }.retriableCall();
                this.bytesUploaded.addAndGet(chunk.length);
                if (!logger.isDebugEnabled()) return;
                logger.debug("Successfully uploaded file with putObject: {} and etag: {}", (Object)path.getRemotePath(), (Object)upload.getETag());
                return;
            }
            catch (Exception e) {
                throw this.encounterError(path, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            this.uploadMultipart(path, in, chunkSize);
        }
    }

    @Override
    public int getActivecount() {
        return this.executor.getActiveCount();
    }

    @Override
    public long bytesUploaded() {
        return this.bytesUploaded.get();
    }

    @Override
    public long bytesDownloaded() {
        return this.bytesDownloaded.get();
    }
}

