/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.netflix.priam.aws.DataPart;
import com.netflix.priam.backup.BackupRestoreException;
import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PartUploader
extends RetryableCallable<Void> {
    private final AmazonS3 client;
    private DataPart dataPart;
    private List<PartETag> partETags;
    private AtomicInteger partsUploaded = null;
    private static final Logger logger = LoggerFactory.getLogger(S3PartUploader.class);
    private static final int MAX_RETRIES = 5;

    public S3PartUploader(AmazonS3 client, DataPart dp, List<PartETag> partETags) {
        super(5, 100L);
        this.client = client;
        this.dataPart = dp;
        this.partETags = partETags;
    }

    public S3PartUploader(AmazonS3 client, DataPart dp, List<PartETag> partETags, AtomicInteger partsUploaded) {
        super(5, 100L);
        this.client = client;
        this.dataPart = dp;
        this.partETags = partETags;
        this.partsUploaded = partsUploaded;
    }

    private Void uploadPart() throws AmazonClientException, BackupRestoreException {
        UploadPartRequest req = new UploadPartRequest();
        req.setBucketName(this.dataPart.getBucketName());
        req.setKey(this.dataPart.getS3key());
        req.setUploadId(this.dataPart.getUploadID());
        req.setPartNumber(this.dataPart.getPartNo());
        req.setPartSize((long)this.dataPart.getPartData().length);
        req.setMd5Digest(SystemUtils.toBase64(this.dataPart.getMd5()));
        req.setInputStream((InputStream)new ByteArrayInputStream(this.dataPart.getPartData()));
        UploadPartResult res = this.client.uploadPart(req);
        PartETag partETag = res.getPartETag();
        if (!partETag.getETag().equals(SystemUtils.toHex(this.dataPart.getMd5()))) {
            throw new BackupRestoreException("Unable to match MD5 for part " + this.dataPart.getPartNo());
        }
        this.partETags.add(partETag);
        if (this.partsUploaded != null) {
            this.partsUploaded.incrementAndGet();
        }
        return null;
    }

    public CompleteMultipartUploadResult completeUpload() throws BackupRestoreException {
        CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.dataPart.getBucketName(), this.dataPart.getS3key(), this.dataPart.getUploadID(), this.partETags);
        return this.client.completeMultipartUpload(compRequest);
    }

    public void abortUpload() {
        AbortMultipartUploadRequest abortRequest = new AbortMultipartUploadRequest(this.dataPart.getBucketName(), this.dataPart.getS3key(), this.dataPart.getUploadID());
        this.client.abortMultipartUpload(abortRequest);
    }

    @Override
    public Void retriableCall() throws AmazonClientException, BackupRestoreException {
        logger.debug("Picked up part {} size {}", (Object)this.dataPart.getPartNo(), (Object)this.dataPart.getPartData().length);
        return this.uploadPart();
    }
}

