/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IMembership;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.Task;
import com.netflix.priam.scheduler.TaskTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UpdateSecuritySettings
extends Task {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSecuritySettings.class);
    public static final String JOBNAME = "Update_SG";
    public static boolean firstTimeUpdated = false;
    private static final Random ran = new Random();
    private final IMembership membership;
    private final IPriamInstanceFactory<PriamInstance> factory;

    @Inject
    public UpdateSecuritySettings(IConfiguration config, IMembership membership, IPriamInstanceFactory factory) {
        super(config);
        this.membership = membership;
        this.factory = factory;
    }

    @Override
    public void execute() {
        int port = this.config.getSSLStoragePort();
        List<String> acls = this.membership.listACL(port, port);
        List<PriamInstance> instances = this.factory.getAllIds(this.config.getAppName());
        HashSet<String> add = new HashSet<String>();
        List<PriamInstance> allInstances = this.factory.getAllIds(this.config.getAppName());
        for (PriamInstance priamInstance : allInstances) {
            String range = priamInstance.getHostIP() + "/32";
            if (acls.contains(range)) continue;
            add.add(range);
        }
        if (add.size() > 0) {
            this.membership.addACL(add, port, port);
            firstTimeUpdated = true;
        }
        ArrayList currentRanges = Lists.newArrayList();
        for (PriamInstance instance : instances) {
            String range = instance.getHostIP() + "/32";
            currentRanges.add(range);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String acl : acls) {
            if (currentRanges.contains(acl)) continue;
            arrayList.add(acl);
        }
        if (arrayList.size() > 0) {
            this.membership.removeACL(arrayList, port, port);
            firstTimeUpdated = true;
        }
    }

    public static TaskTimer getTimer(InstanceIdentity id) {
        SimpleTimer return_;
        if (id.isSeed()) {
            logger.info("Seed node.  Instance id: {}, host ip: {}, host name: {}", new Object[]{id.getInstance().getInstanceId(), id.getInstance().getHostIP(), id.getInstance().getHostName()});
            return_ = new SimpleTimer(JOBNAME, 120000 + ran.nextInt(120000));
        } else {
            return_ = new SimpleTimer(JOBNAME);
        }
        return return_;
    }

    @Override
    public String getName() {
        return JOBNAME;
    }
}

