/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupRestoreUtil {
    private static final Logger logger = LoggerFactory.getLogger(BackupRestoreUtil.class);
    private static final String JOBNAME = "BackupRestoreUtil";
    private final Map<String, List<String>> columnFamilyFilter = new HashMap<String, List<String>>();
    private final Map<String, Object> keyspaceFilter = new HashMap<String, Object>();
    private final Pattern columnFamilyFilterPattern = Pattern.compile(".\\..");
    private String configKeyspaceFilter;
    private String configColumnfamilyFilter;
    public static final List<String> FILTER_KEYSPACE = Arrays.asList("OpsCenter");
    private static final Map<String, List<String>> FILTER_COLUMN_FAMILY = ImmutableMap.of((Object)"system", Arrays.asList("local", "peers", "compactions_in_progress", "LocationInfo"));

    @Inject
    public BackupRestoreUtil(String configKeyspaceFilter, String configColumnfamilyFilter) {
        this.setFilters(configKeyspaceFilter, configColumnfamilyFilter);
    }

    private BackupRestoreUtil setFilters(String configKeyspaceFilter, String configColumnfamilyFilter) {
        this.configColumnfamilyFilter = configColumnfamilyFilter;
        this.configKeyspaceFilter = configKeyspaceFilter;
        this.populateFilters();
        return this;
    }

    private final boolean isValidCFFilterFormat(String cfFilter) {
        return this.columnFamilyFilterPattern.matcher(cfFilter).find();
    }

    private final void populateFilters() {
        int i;
        this.keyspaceFilter.clear();
        this.columnFamilyFilter.clear();
        if (this.configKeyspaceFilter == null || this.configKeyspaceFilter.isEmpty()) {
            logger.info("No keyspace filter set for {}.", (Object)JOBNAME);
        } else {
            String[] keyspaces = this.configKeyspaceFilter.split(",");
            for (i = 0; i < keyspaces.length; ++i) {
                logger.info("Adding {} keyspace filter: {}", (Object)JOBNAME, (Object)keyspaces[i]);
                this.keyspaceFilter.put(keyspaces[i], null);
            }
        }
        if (this.configColumnfamilyFilter == null || this.configColumnfamilyFilter.isEmpty()) {
            logger.info("No column family filter set for {}.", (Object)JOBNAME);
        } else {
            String[] filters = this.configColumnfamilyFilter.split(",");
            for (i = 0; i < filters.length; ++i) {
                if (this.isValidCFFilterFormat(filters[i])) {
                    String[] filter = filters[i].split("\\.");
                    String ksName = filter[0];
                    String cfName = filter[1];
                    logger.info("Adding {} CF filter: {}.{}", new Object[]{JOBNAME, ksName, cfName});
                    if (this.columnFamilyFilter.containsKey(ksName)) {
                        List<String> columnfamilies = this.columnFamilyFilter.get(ksName);
                        columnfamilies.add(cfName);
                        this.columnFamilyFilter.put(ksName, columnfamilies);
                        continue;
                    }
                    ArrayList<String> cfs = new ArrayList<String>();
                    cfs.add(cfName);
                    this.columnFamilyFilter.put(ksName, cfs);
                    continue;
                }
                throw new IllegalArgumentException("Column family filter format is not valid.  Format needs to be \"keyspace.columnfamily\".  Invalid input: " + filters[i]);
            }
        }
    }

    public final boolean isFiltered(String keyspace, String columnFamilyDir) {
        if (StringUtils.isEmpty((CharSequence)keyspace) || StringUtils.isEmpty((CharSequence)columnFamilyDir)) {
            return false;
        }
        String columnFamilyName = columnFamilyDir.split("-")[0];
        if (FILTER_COLUMN_FAMILY.containsKey(keyspace) && FILTER_COLUMN_FAMILY.get(keyspace).contains(columnFamilyName)) {
            return true;
        }
        if (this.isFiltered(DIRECTORYTYPE.KEYSPACE, keyspace) || this.isFiltered(DIRECTORYTYPE.CF, keyspace, columnFamilyDir)) {
            logger.debug("Skipping: keyspace: {}, CF: {} is part of filter list.", (Object)keyspace, (Object)columnFamilyName);
            return true;
        }
        return false;
    }

    private final boolean isFiltered(DIRECTORYTYPE directoryType, String ... args) {
        Matcher matcher;
        Pattern pattern;
        String keyspaceName;
        if (directoryType.equals((Object)DIRECTORYTYPE.KEYSPACE)) {
            keyspaceName = args[0];
            Set<String> ksFilters = this.keyspaceFilter.keySet();
            for (String ksFilter : ksFilters) {
                pattern = Pattern.compile(ksFilter);
                matcher = pattern.matcher(keyspaceName);
                if (!matcher.find()) continue;
                logger.debug("Keyspace: {} matched filter: {}", (Object)keyspaceName, (Object)ksFilter);
                return true;
            }
        }
        if (directoryType.equals((Object)DIRECTORYTYPE.CF)) {
            keyspaceName = args[0];
            if (!this.columnFamilyFilter.containsKey(keyspaceName)) {
                return false;
            }
            String cfName = args[1];
            List<String> cfsFilter = this.columnFamilyFilter.get(keyspaceName);
            for (int i = 0; i < cfsFilter.size(); ++i) {
                pattern = Pattern.compile(cfsFilter.get(i));
                matcher = pattern.matcher(cfName);
                if (!matcher.find()) continue;
                logger.debug("{}.{} matched filter", (Object)keyspaceName, (Object)cfName);
                return true;
            }
        }
        return false;
    }

    public static enum DIRECTORYTYPE {
        KEYSPACE,
        CF;

    }
}

