/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.netflix.priam.backup.AbstractBackup;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.CommitLogBackup;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backup.IMessageObserver;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.TaskTimer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CommitLogBackupTask
extends AbstractBackup {
    public static String JOBNAME = "CommitLogBackup";
    private static final Logger logger = LoggerFactory.getLogger(CommitLogBackupTask.class);
    private final List<String> clRemotePaths = new ArrayList<String>();
    private static List<IMessageObserver> observers = new ArrayList<IMessageObserver>();
    private final CommitLogBackup clBackup;

    @Inject
    public CommitLogBackupTask(IConfiguration config, Provider<AbstractBackupPath> pathFactory, CommitLogBackup clBackup, IFileSystemContext backupFileSystemCtx) {
        super(config, backupFileSystemCtx, pathFactory);
        this.clBackup = clBackup;
    }

    @Override
    public void execute() throws Exception {
        try {
            logger.debug("Checking for any archived commitlogs");
            if (this.config.isBackingUpCommitLogs()) {
                this.clBackup.upload(this.config.getCommitLogBackupRestoreFromDirs(), null);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    public static TaskTimer getTimer(IConfiguration config) {
        return new SimpleTimer(JOBNAME, 60000L);
    }

    public static void addObserver(IMessageObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(IMessageObserver observer) {
        observers.remove(observer);
    }

    public void notifyObservers() {
        for (IMessageObserver observer : observers) {
            if (observer != null) {
                logger.debug("Updating CL observers now ...");
                observer.update(IMessageObserver.BACKUP_MESSAGE_TYPE.COMMITLOG, this.clRemotePaths);
                continue;
            }
            logger.info("Observer is Null, hence can not notify ...");
        }
    }

    @Override
    protected void processColumnFamily(String keyspace, String columnFamily, File backupDir) throws Exception {
    }

    @Override
    protected void addToRemotePath(String remotePath) {
        this.clRemotePaths.add(remotePath);
    }
}

