/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.Inject;
import com.netflix.priam.backup.BackupMetadata;
import com.netflix.priam.backup.BackupStatusMgr;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.utils.MaxSizeHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FileSnapshotStatusMgr
extends BackupStatusMgr {
    private static final Logger logger = LoggerFactory.getLogger(FileSnapshotStatusMgr.class);
    private static final int IN_MEMORY_SNAPSHOT_CAPACITY = 60;
    private String filename;

    @Inject
    public FileSnapshotStatusMgr(IConfiguration config, InstanceState instanceState) {
        super(60, instanceState);
        this.filename = config.getBackupStatusFileLoc();
        this.init();
    }

    private void init() {
        File snapshotFile = new File(this.filename);
        if (!snapshotFile.exists()) {
            logger.info("Snapshot status file do not exist on system. Bypassing initilization phase.");
            return;
        }
        try (ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(snapshotFile));){
            this.backupMetadataMap = (Map)inputStream.readObject();
            logger.info("Snapshot status of size {} fetched successfully from {}", (Object)this.backupMetadataMap.size(), (Object)this.filename);
        }
        catch (IOException e) {
            logger.error("Error while trying to fetch snapshot status from {}. Error: {}. If this is first time after upgrading Priam, ignore this.", (Object)this.filename, (Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error("Error while trying to fetch snapshot status from {}. Error: {}.", (Object)this.filename, (Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
        if (this.backupMetadataMap == null) {
            this.backupMetadataMap = new MaxSizeHashMap(this.capacity);
        }
    }

    @Override
    public void save(BackupMetadata backupMetadata) {
        File snapshotFile = new File(this.filename);
        if (!snapshotFile.exists()) {
            snapshotFile.mkdirs();
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filename));){
            out.writeObject(this.backupMetadataMap);
            out.flush();
            logger.info("Snapshot status of size {} is saved to {}", (Object)this.backupMetadataMap.size(), (Object)this.filename);
        }
        catch (IOException e) {
            logger.error("Error while trying to persist snapshot status to {}. Error: {}", (Object)this.filename, (Object)e.getLocalizedMessage());
        }
    }

    @Override
    public LinkedList<BackupMetadata> fetch(String snapshotDate) {
        return (LinkedList)this.backupMetadataMap.get(snapshotDate);
    }
}

