/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup.parallel;

import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.parallel.BackupPostProcessingCallback;
import com.netflix.priam.utils.RetryableCallable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalConsumer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalConsumer.class);
    private AbstractBackupPath bp;
    private IBackupFileSystem fs;
    private BackupPostProcessingCallback<AbstractBackupPath> callback;

    public IncrementalConsumer(AbstractBackupPath bp, IBackupFileSystem fs, BackupPostProcessingCallback<AbstractBackupPath> callback) {
        this.bp = bp;
        this.bp.setType(AbstractBackupPath.BackupFileType.SST);
        this.fs = fs;
        this.callback = callback;
    }

    @Override
    public void run() {
        logger.info("Consumer - about to upload file: {}", (Object)this.bp.getFileName());
        try {
            new RetryableCallable<Void>(){

                @Override
                public Void retriableCall() throws Exception {
                    InputStream is = null;
                    try {
                        is = IncrementalConsumer.this.bp.localReader();
                    }
                    catch (FileNotFoundException | RuntimeException e) {
                        if (is != null) {
                            is.close();
                        }
                        throw new CancellationException("Someone beat me to uploading this file, no need to retry.  Most likely not needed but to be safe, checked and released handle to file if appropriate.");
                    }
                    try {
                        if (is == null) {
                            throw new NullPointerException("Unable to get handle on file: " + IncrementalConsumer.this.bp.getFileName());
                        }
                        IncrementalConsumer.this.fs.upload(IncrementalConsumer.this.bp, is);
                        IncrementalConsumer.this.bp.setCompressedFileSize(IncrementalConsumer.this.fs.getBytesUploaded());
                        return null;
                    }
                    catch (Exception e) {
                        logger.error("Exception uploading local file {},  releasing handle, and will retry.", (Object)IncrementalConsumer.this.bp.getFileName());
                        if (is != null) {
                            is.close();
                        }
                        throw e;
                    }
                }
            }.call();
            this.bp.getBackupFile().delete();
            this.callback.postProcessing(this.bp);
        }
        catch (Exception e) {
            if (e instanceof CancellationException) {
                logger.debug("Failed to upload local file {}. Ignoring to continue with rest of backup.  Msg: {}", (Object)this.bp.getFileName(), (Object)e.getLocalizedMessage());
            }
            logger.error("Failed to upload local file {}. Ignoring to continue with rest of backup.  Msg: {}", (Object)this.bp.getFileName(), (Object)e.getLocalizedMessage());
        }
    }
}

