/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.cluster.management;

import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.merics.IMeasurement;
import com.netflix.priam.utils.CassandraMonitor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IClusterManagement<T>
extends com.netflix.priam.scheduler.Task {
    private static final Logger logger = LoggerFactory.getLogger(IClusterManagement.class);
    private Task taskType;
    private IMeasurement measurement;
    private static Lock lock = new ReentrantLock();

    protected IClusterManagement(IConfiguration config, Task taskType, IMeasurement measurement) {
        super(config);
        this.taskType = taskType;
        this.measurement = measurement;
    }

    @Override
    public void execute() throws Exception {
        if (!CassandraMonitor.hasCassadraStarted().booleanValue()) {
            logger.debug("Cassandra has not started, hence {} will not run", (Object)this.taskType);
            return;
        }
        if (!lock.tryLock()) {
            logger.error("Operation is already running! Try again later.");
            throw new Exception("Operation already running");
        }
        try {
            String result = this.runTask();
            this.measurement.incrementSuccess();
            logger.info("Successfully finished executing the cluster management task: {} with result: {}", (Object)this.taskType, (Object)result);
            if (result.isEmpty()) {
                logger.warn("{} task completed successfully but no action was done.", (Object)this.taskType.name());
            }
        }
        catch (Exception e) {
            this.measurement.incrementFailure();
            throw new Exception("Exception during execution of operation: " + this.taskType.name(), e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getName() {
        return this.taskType.name();
    }

    protected abstract String runTask() throws Exception;

    public static enum Task {
        FLUSH,
        COMPACTION;

    }
}

