/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.configSource;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.netflix.priam.configSource.AbstractConfigSource;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigSource
extends AbstractConfigSource {
    private static final Logger logger = LoggerFactory.getLogger((String)PropertiesConfigSource.class.getName());
    private static final String DEFAULT_PRIAM_PROPERTIES = "Priam.properties";
    private final Map<String, String> data = Maps.newConcurrentMap();
    private final String priamFile;

    public PropertiesConfigSource() {
        this.priamFile = DEFAULT_PRIAM_PROPERTIES;
    }

    public PropertiesConfigSource(Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        this.priamFile = DEFAULT_PRIAM_PROPERTIES;
        this.clone(properties);
    }

    @VisibleForTesting
    PropertiesConfigSource(String file) {
        this.priamFile = (String)Preconditions.checkNotNull((Object)file);
    }

    @Override
    public void intialize(String asgName, String region) {
        super.intialize(asgName, region);
        Properties properties = new Properties();
        URL url = PropertiesConfigSource.class.getClassLoader().getResource(this.priamFile);
        if (url != null) {
            try {
                properties.load(url.openStream());
                this.clone(properties);
            }
            catch (IOException e) {
                logger.info("No Priam.properties. Ignore!");
            }
        } else {
            logger.info("No Priam.properties. Ignore!");
        }
    }

    @Override
    public String get(String prop) {
        return this.data.get(prop);
    }

    @Override
    public void set(String key, String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value can not be null for configurations.");
        this.data.put(key, value);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean contains(String prop) {
        return this.data.containsKey(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clone(Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        Properties properties2 = properties;
        synchronized (properties2) {
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                if (Strings.isNullOrEmpty((String)value)) continue;
                this.data.put(key, value);
            }
        }
    }
}

